package net.glasslauncher.mods.alwaysmoreitems.mixin;

import com.mojang.datafixers.util.Either;
import net.glasslauncher.mods.alwaysmoreitems.api.SyncableRecipe;
import net.glasslauncher.mods.alwaysmoreitems.plugins.vanilla.VanillaPlugin;
import net.minecraft.class_124;
import net.minecraft.class_202;
import net.minecraft.class_31;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.tag.TagKey;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.impl.recipe.StationShapelessRecipe;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(StationShapelessRecipe.class)
public class StationShapelessRecipeMixin implements SyncableRecipe {

    @Shadow @Final private class_31 output;

    @Shadow(remap = false) @Final private Either<TagKey<class_124>, class_31>[] ingredients;

    @Override
    public class_8 exportRecipe() {
        class_8 recipe = new class_8();
        class_202 inputs = new class_202();
        recipe.method_1017("input", inputs);
        for (Either<TagKey<class_124>, class_31> either : ingredients) {
            if (either.right().isPresent()) {
                class_8 item = new class_8();
                either.right().get().method_706(item);
                inputs.method_1397(item);
            }
            else {
                class_8 id = new class_8();
                id.method_1019("identifier", either.left().get().id().toString());
                inputs.method_1397(id);
            }
        }
        class_8 item = new class_8();
        output.method_706(item);
        recipe.method_1018("output", item);

        recipe.method_1012("type", (byte) 3);
        return recipe;
    }

    @Override
    public Identifier getPlugin() {
        return VanillaPlugin.ID;
    }
}
