package net.glasslauncher.mods.alwaysmoreitems.plugins.vanilla;

import com.mojang.datafixers.util.Either;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.glasslauncher.mods.alwaysmoreitems.api.AMIHelpers;
import net.glasslauncher.mods.alwaysmoreitems.api.ItemRegistry;
import net.glasslauncher.mods.alwaysmoreitems.api.ModPluginProvider;
import net.glasslauncher.mods.alwaysmoreitems.api.ModRegistry;
import net.glasslauncher.mods.alwaysmoreitems.api.RecipeRegistry;
import net.glasslauncher.mods.alwaysmoreitems.api.SyncableRecipe;
import net.glasslauncher.mods.alwaysmoreitems.api.recipe.VanillaRecipeCategoryUid;
import net.glasslauncher.mods.alwaysmoreitems.api.recipe.transfer.RecipeTransferRegistry;
import net.glasslauncher.mods.alwaysmoreitems.plugins.vanilla.crafting.CraftingRecipeCategory;
import net.glasslauncher.mods.alwaysmoreitems.plugins.vanilla.crafting.ShapedOreRecipeHandler;
import net.glasslauncher.mods.alwaysmoreitems.plugins.vanilla.crafting.ShapedRecipesHandler;
import net.glasslauncher.mods.alwaysmoreitems.plugins.vanilla.crafting.ShapelessOreRecipeHandler;
import net.glasslauncher.mods.alwaysmoreitems.plugins.vanilla.crafting.ShapelessRecipesHandler;
import net.glasslauncher.mods.alwaysmoreitems.plugins.vanilla.furnace.FuelRecipe;
import net.glasslauncher.mods.alwaysmoreitems.plugins.vanilla.furnace.FuelRecipeHandler;
import net.glasslauncher.mods.alwaysmoreitems.plugins.vanilla.furnace.FuelRecipeMaker;
import net.glasslauncher.mods.alwaysmoreitems.plugins.vanilla.furnace.FurnaceFuelCategory;
import net.glasslauncher.mods.alwaysmoreitems.plugins.vanilla.furnace.FurnaceSmeltingCategory;
import net.glasslauncher.mods.alwaysmoreitems.plugins.vanilla.furnace.SmeltingRecipe;
import net.glasslauncher.mods.alwaysmoreitems.plugins.vanilla.furnace.SmeltingRecipeHandler;
import net.glasslauncher.mods.alwaysmoreitems.plugins.vanilla.furnace.SmeltingRecipeMaker;
import net.glasslauncher.mods.alwaysmoreitems.util.AlwaysMoreItems;
import net.minecraft.class_124;
import net.minecraft.class_148;
import net.minecraft.class_193;
import net.minecraft.class_196;
import net.minecraft.class_202;
import net.minecraft.class_31;
import net.minecraft.class_337;
import net.minecraft.class_453;
import net.minecraft.class_516;
import net.minecraft.class_524;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.tag.TagKey;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.impl.recipe.StationShapedRecipe;
import net.modificationstation.stationapi.impl.recipe.StationShapelessRecipe;

import java.util.*;

public class VanillaPlugin implements ModPluginProvider {
	public static final Identifier ID = AlwaysMoreItems.NAMESPACE.id("vanilla");

	private ItemRegistry itemRegistry;
	private AMIHelpers amiHelpers;

	@Override
	public String getName() {
		return "Vanilla";
	}

	@Override
	public Identifier getId() {
		return ID;
	}

	@Override
	public void onAMIHelpersAvailable(AMIHelpers amiHelpers) {
		this.amiHelpers = amiHelpers;
	}

	@Override
	public void onItemRegistryAvailable(ItemRegistry itemRegistry) {
		this.itemRegistry = itemRegistry;
	}

	@Override
	public void register(ModRegistry registry) {
		registry.addRecipeCategories(
				new CraftingRecipeCategory(),
				new FurnaceFuelCategory(),
				new FurnaceSmeltingCategory()
		);

		registry.addRecipeHandlers(
				new ShapedOreRecipeHandler(),
				new ShapedRecipesHandler(),
				new ShapelessOreRecipeHandler(),
				new ShapelessRecipesHandler(),
				new FuelRecipeHandler(),
				new SmeltingRecipeHandler()
		);

		if (FabricLoader.getInstance().getEnvironmentType().equals(EnvType.CLIENT)) {
			registry.addRecipeClickArea(class_516.class, 88, 32, 28, 23, VanillaRecipeCategoryUid.CRAFTING);
			registry.addRecipeClickArea(class_524.class, 78, 32, 28, 23, VanillaRecipeCategoryUid.SMELTING, VanillaRecipeCategoryUid.FUEL);
		}

		RecipeTransferRegistry recipeTransferRegistry = registry.getRecipeTransferRegistry();

		recipeTransferRegistry.addRecipeTransferHandler(class_196.class, VanillaRecipeCategoryUid.CRAFTING, 1, 9, 10, 36);
		recipeTransferRegistry.addRecipeTransferHandler(class_337.class, VanillaRecipeCategoryUid.SMELTING, 0, 1, 3, 36);
		recipeTransferRegistry.addRecipeTransferHandler(class_337.class, VanillaRecipeCategoryUid.FUEL, 1, 1, 3, 36);

		registry.addRecipes(class_148.method_538().method_541());
		registry.addRecipes(SmeltingRecipeMaker.getFurnaceRecipes(amiHelpers));
		registry.addRecipes(FuelRecipeMaker.getFuelRecipes(itemRegistry, amiHelpers));
	}

	@Override
	public void onRecipeRegistryAvailable(RecipeRegistry recipeRegistry) {

	}

	@Override
	public SyncableRecipe deserializeRecipe(class_8 recipe) {
        return switch (recipe.method_1025("type")) {
            case 1 -> // Vanilla shapeless
                    (SyncableRecipe) new class_453(new class_31(recipe.method_1033("output")), Arrays.asList(parseInputs(recipe.method_1034("input"))));
            case 2 -> // Vanilla shaped
                    (SyncableRecipe) new class_193(recipe.method_1027("width"), recipe.method_1027("height"), parseInputs(recipe.method_1034("input")), new class_31(recipe.method_1033("output")));
            case 3 -> // StAPI shapeless
                    (SyncableRecipe) new StationShapelessRecipe(new class_31(recipe.method_1033("output")), parseStapiInputs(recipe.method_1034("input")));
            case 4 -> // StAPI shaped
                    (SyncableRecipe) new StationShapedRecipe(recipe.method_1027("width"), recipe.method_1027("height"), parseStapiInputs(recipe.method_1034("input")), new class_31(recipe.method_1033("output")));
            case 5 -> // Furnace
                    new SmeltingRecipe(Collections.singletonList(new class_31(recipe.method_1033("input"))), new class_31(recipe.method_1033("output")));
			case 6 -> // Furnace fuel
					new FuelRecipe(List.of(parseInputs(recipe.method_1034("input"))), recipe.method_1027("burnTime"));
            default -> null;
        };
    }

	public static class_31[] parseInputs(class_202 inputs) {
		class_31[] outputs = new class_31[inputs.method_1398()];
		for (int i = 0; i < inputs.method_1398(); i++) {
			if (((class_8) inputs.method_1396(i)).method_1025("Count") == 0) {
				continue;
			}
			outputs[i] = new class_31((class_8) inputs.method_1396(i));
		}
		return outputs;
	}

	public static Either<TagKey<class_124>, class_31>[] parseStapiInputs(class_202 inputs) {
        //noinspection unchecked
        Either<TagKey<class_124>, class_31>[] outputs = new Either[inputs.method_1398()];
		for (int i = 0; i < inputs.method_1398(); i++) {
			class_8 input = (class_8) inputs.method_1396(i);
            if (!input.method_1031("identifier").isEmpty()) {
				outputs[i] = Either.left(TagKey.of(net.modificationstation.stationapi.api.registry.ItemRegistry.KEY, Identifier.of(input.method_1031("identifier"))));
				continue;
			}
			if (((class_8) inputs.method_1396(i)).method_1025("Count") == 0) {
				continue;
			}
            outputs[i] = Either.right(new class_31(input));
		}
		return outputs;
	}
}
