package net.glasslauncher.mods.alwaysmoreitems.plugins.vanilla.furnace;

import net.glasslauncher.mods.alwaysmoreitems.api.SyncableRecipe;
import net.glasslauncher.mods.alwaysmoreitems.plugins.vanilla.VanillaPlugin;
import net.glasslauncher.mods.alwaysmoreitems.plugins.vanilla.VanillaRecipeWrapper;
import net.minecraft.class_31;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.util.Identifier;

import javax.annotation.*;
import java.util.*;

public class SmeltingRecipe extends VanillaRecipeWrapper implements SyncableRecipe {
	@Nonnull
	private final List<List<class_31>> input;
	@Nonnull
	private final List<class_31> outputs;

	public SmeltingRecipe(@Nonnull List<class_31> input, @Nonnull class_31 output) {
		this.input = Collections.singletonList(input);
		this.outputs = Collections.singletonList(output);
	}

	@Nonnull
	public List<List<class_31>> getInputs() {
		return input;
	}

	@Nonnull
	public List<class_31> getOutputs() {
		return outputs;
	}

	@Override
	public class_8 exportRecipe() {
		class_8 nbtCompound = new class_8();

		class_8 itemNbt = new class_8();
		input.get(0).get(0).method_706(itemNbt);
		nbtCompound.method_1018("input", itemNbt);

		itemNbt = new class_8();
		outputs.get(0).method_706(itemNbt);
		nbtCompound.method_1018("output", itemNbt);

		nbtCompound.method_1012("type", (byte) 5);

		return nbtCompound;
	}

	@Override
	public Identifier getPlugin() {
		return VanillaPlugin.ID;
	}
}
