package net.glasslauncher.mods.alwaysmoreitems.plugins.vanilla.furnace;

import net.glasslauncher.mods.alwaysmoreitems.api.AMIHelpers;
import net.glasslauncher.mods.alwaysmoreitems.api.SubProvider;
import net.glasslauncher.mods.alwaysmoreitems.api.recipe.StackHelper;
import net.minecraft.class_124;
import net.minecraft.class_31;
import net.minecraft.class_44;
import net.modificationstation.stationapi.api.registry.ItemRegistry;
import net.modificationstation.stationapi.api.registry.RegistryEntryList;
import net.modificationstation.stationapi.api.tag.TagKey;

import javax.annotation.*;
import java.util.*;

public class SmeltingRecipeMaker {

	@Nonnull
	public static List<SmeltingRecipe> getFurnaceRecipes(AMIHelpers helpers) {
		StackHelper stackHelper = helpers.getStackHelper();
        //noinspection unchecked
        Map<?, class_31> smeltingMap = class_44.method_144().method_147();

		List<SmeltingRecipe> recipes = new ArrayList<>();

		for (Map.Entry<?, class_31> itemStackItemStackEntry : smeltingMap.entrySet()) {

			List<class_31> inputs;

			Object objItem = itemStackItemStackEntry.getKey();
			if (objItem instanceof TagKey<?> key) {
                //noinspection unchecked
                Optional<RegistryEntryList.Named<class_124>> instanceEntryList = ItemRegistry.INSTANCE.getEntryList((TagKey<class_124>) key);
				if (instanceEntryList.isEmpty()) {
					continue;
				}
				inputs = new ArrayList<>();
				instanceEntryList.ifPresent(
						registryEntries -> registryEntries.forEach(itemRegistryEntry -> {
							inputs.addAll(((SubProvider) itemRegistryEntry.value()).getSubItems());
						})
				);
			}
			else if (objItem instanceof class_31 itemStack) {
				inputs = stackHelper.getSubtypes(itemStack);
			}
			else {
				inputs = Collections.singletonList(new class_31((int) objItem, 1, 0));
			}

			class_31 output = itemStackItemStackEntry.getValue();

			SmeltingRecipe recipe = new SmeltingRecipe(inputs, output);
			recipes.add(recipe);
		}

		return recipes;
	}

}
