package net.glasslauncher.mods.alwaysmoreitems.api.recipe;

import javax.annotation.*;
import net.minecraft.class_31;
import java.util.*;

/**
 * Helps get ItemStacks from common formats used in recipes.
 */
public interface StackHelper {
    /**
     * Returns all the subtypes of itemStack if it has a wildcard meta value.
     */
    @Nonnull
    List<class_31> getSubtypes(@Nonnull class_31 itemStack);

    /**
     * Expands an Iterable, which may contain ItemStacks or more Iterables, and
     * returns all the subtypes of itemStacks if they have wildcard meta value.
     */
    @Nonnull
    List<class_31> getAllSubtypes(@Nonnull Iterable stacks);

    /**
     * Flattens ItemStacks, OreDict Strings, and Iterables into a list of ItemStacks.
     */
    @Nonnull
    List<class_31> toItemStackList(@Nullable Object stacks);
}
