package net.glasslauncher.mods.alwaysmoreitems.network.s2c;

import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.glasslauncher.mods.alwaysmoreitems.api.ModPluginProvider;
import net.glasslauncher.mods.alwaysmoreitems.api.SyncableRecipe;
import net.glasslauncher.mods.alwaysmoreitems.init.CommonInit;
import net.glasslauncher.mods.alwaysmoreitems.network.NetworkHelper;
import net.glasslauncher.mods.alwaysmoreitems.util.AlwaysMoreItems;
import net.glasslauncher.mods.alwaysmoreitems.util.ModRegistry;
import net.minecraft.class_169;
import net.minecraft.class_202;
import net.minecraft.class_240;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.network.packet.IdentifiablePacket;
import net.modificationstation.stationapi.api.util.Identifier;

import java.io.*;
import java.util.*;

/**
 * This is a LARGE packet, so don't resend it, instead make a blacklist plugin instead of fucking with this packet.
 * I'm not kidding, this thing's going to end up multiple megabytes in size on even a small modpack, nevermind when you load 100+ mods.
 */
public class RecipeSyncPacket extends class_169 implements IdentifiablePacket {
    private static final Identifier IDENTIFIER = AlwaysMoreItems.NAMESPACE.id("sync");
    private static final String PLUGIN_KEY = AlwaysMoreItems.NAMESPACE.id("plugin").toString();

    private static class_202 CACHED_DATA;

    private int outSize;
    private ArrayList<SyncableRecipe> readData;

    @Override
    public void method_806(DataInputStream stream) {
        class_202 nbtList = new class_202();
        nbtList.method_630(stream);
        ArrayList<SyncableRecipe> recipes = new ArrayList<>();
        for (int i = 0; i < nbtList.method_1398(); i++) {
            class_8 nbtCompound = (class_8) nbtList.method_1396(i);
            String pluginKey = nbtCompound.method_1031(PLUGIN_KEY);
            ModPluginProvider plugin = CommonInit.getPlugins().get(Identifier.of(pluginKey));
            if (plugin == null) {
                AlwaysMoreItems.LOGGER.warn("Plugin {} not found, recipes from this plugin won't function. Are you missing a mod?", pluginKey);
                continue;
            }
            SyncableRecipe syncableRecipe = plugin.deserializeRecipe(nbtCompound);
            if (syncableRecipe != null) {
                recipes.add(syncableRecipe);
            }
        }
        readData = recipes;
    }

    @Override
    public void method_807(DataOutputStream stream) {
        if (CACHED_DATA == null) {
            AlwaysMoreItems.LOGGER.info("Loading recipes to server cache.");
            CACHED_DATA = new class_202();
            AlwaysMoreItems.getRecipeRegistry().getSyncableRecipes().forEach(syncableRecipe -> {
                NbtCompound nbtCompound = syncableRecipe.exportRecipe();
                nbtCompound.putString(PLUGIN_KEY, syncableRecipe.getPlugin().toString());
                CACHED_DATA.add(nbtCompound);
            });
        }
        outSize = NetworkHelper.writeAndGetNbtLength(CACHED_DATA, stream);
    }

    @Override
    public void method_808(class_240 networkHandler) {
        if (FabricLoader.getInstance().getEnvironmentType().equals(EnvType.SERVER)) {
            return;
        }
        // Holy shit this code is awful.
        // TODO: Make this way less awful when I find the inspiration
        ModRegistry modRegistry = new ModRegistry(CommonInit.getModRegistry());
        modRegistry.addRecipes(readData);
        modRegistry.addRecipes(AlwaysMoreItems.getRecipeRegistry().getUnsyncableRecipes());
        AlwaysMoreItems.setRecipeRegistry(modRegistry.createRecipeRegistry());
        AlwaysMoreItems.LOGGER.info("Synced {} recipes from server to client, skipped {} unhandled recipes.", readData.size(), AlwaysMoreItems.getRecipeRegistry().getUnsyncableRecipes().size());
    }

    @Override
    public int method_798() {
        return outSize;
    }

    @Override
    public Identifier getId() {
        return IDENTIFIER;
    }

    public static void register() {
        IdentifiablePacket.register(IDENTIFIER, true, false, RecipeSyncPacket::new);
    }
}
