package net.glasslauncher.mods.alwaysmoreitems.plugins.vanilla.crafting;

import net.glasslauncher.mods.alwaysmoreitems.api.recipe.RecipeHandler;
import net.glasslauncher.mods.alwaysmoreitems.api.recipe.RecipeWrapper;
import net.glasslauncher.mods.alwaysmoreitems.api.recipe.VanillaRecipeCategoryUid;
import net.minecraft.class_31;
import net.minecraft.class_453;
import javax.annotation.*;

public class ShapelessRecipesHandler implements RecipeHandler<class_453> {

	@Override
	@Nonnull
	public Class<class_453> getRecipeClass() {
		return class_453.class;
	}

	@Nonnull
	@Override
	public String getRecipeCategoryUid() {
		return VanillaRecipeCategoryUid.CRAFTING;
	}

	@Override
	@Nonnull
	public RecipeWrapper getRecipeWrapper(@Nonnull class_453 recipe) {
		return new ShapelessRecipesWrapper(recipe);
	}

	@Override
	public boolean isRecipeValid(@Nonnull class_453 recipe) {
		if (recipe.method_2073() == null) {
			return false;
		}
		int inputCount = 0;
		for (Object input : recipe.field_1720) {
			if (input instanceof class_31) {
				inputCount++;
			} else {
				return false;
			}
		}
		return inputCount > 0;
	}
}
