/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.gui.widget;

import javax.annotation.Nonnull;
import net.glasslauncher.mods.alwaysmoreitems.api.gui.StaticDrawable;
import net.glasslauncher.mods.alwaysmoreitems.gui.AMIDrawContext;
import net.minecraft.class_67;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class DrawableResource
implements StaticDrawable {
    @Nonnull
    private final String resourceLocation;
    private final int u;
    private final int v;
    private final int width;
    private final int height;
    private final int paddingTop;
    private final int paddingBottom;
    private final int paddingLeft;
    private final int paddingRight;

    public DrawableResource(@Nonnull String resourceLocation, int u, int v, int width, int height) {
        this(resourceLocation, u, v, width, height, 0, 0, 0, 0);
    }

    public DrawableResource(@Nonnull String resourceLocation, int u, int v, int width, int height, int paddingTop, int paddingBottom, int paddingLeft, int paddingRight) {
        this.resourceLocation = resourceLocation;
        this.u = u;
        this.v = v;
        this.width = width;
        this.height = height;
        this.paddingTop = paddingTop;
        this.paddingBottom = paddingBottom;
        this.paddingLeft = paddingLeft;
        this.paddingRight = paddingRight;
    }

    @Override
    public int getWidth() {
        return this.width + this.paddingLeft + this.paddingRight;
    }

    @Override
    public int getHeight() {
        return this.height + this.paddingTop + this.paddingBottom;
    }

    @Override
    public void draw(@Nonnull Minecraft minecraft) {
        this.draw(minecraft, 0, 0);
    }

    @Override
    public void draw(@Nonnull Minecraft minecraft, int xOffset, int yOffset) {
        this.draw(minecraft, xOffset, yOffset, 0, 0, 0, 0);
    }

    @Override
    public void draw(@Nonnull Minecraft minecraft, int xOffset, int yOffset, int maskTop, int maskBottom, int maskLeft, int maskRight) {
        minecraft.field_2814.method_1097(minecraft.field_2814.method_1100(this.resourceLocation));
        int x = xOffset + this.paddingLeft + maskLeft;
        int y = yOffset + this.paddingTop + maskTop;
        int u = this.u + maskLeft;
        int v = this.v + maskTop;
        int width = this.width - maskRight - maskLeft;
        int height = this.height - maskBottom - maskTop;
        AMIDrawContext.INSTANCE.method_1936(x, y, u, v, width, height);
    }

    public void renderBackgroundTexture(int vOFfset) {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        class_67 var2 = class_67.field_2054;
        GL11.glBindTexture((int)3553, (int)Minecraft.field_2791.field_2814.method_1100("/gui/background.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float var3 = 32.0f;
        var2.method_1695();
        var2.method_1698(0x404040);
        var2.method_1688(0.0, (double)this.height, 0.0, 0.0, (double)((float)this.height / var3 + (float)vOFfset));
        var2.method_1688((double)this.width, (double)this.height, 0.0, (double)((float)this.width / var3), (double)((float)this.height / var3 + (float)vOFfset));
        var2.method_1688((double)this.width, 0.0, 0.0, (double)((float)this.width / var3), (double)vOFfset);
        var2.method_1688(0.0, 0.0, 0.0, 0.0, (double)vOFfset);
        var2.method_1685();
    }
}

