/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.init;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.glasslauncher.mods.alwaysmoreitems.api.ModPluginProvider;
import net.glasslauncher.mods.alwaysmoreitems.network.c2s.ActionButtonPacket;
import net.glasslauncher.mods.alwaysmoreitems.network.c2s.GiveItemPacket;
import net.glasslauncher.mods.alwaysmoreitems.network.c2s.RecipeTransferPacket;
import net.glasslauncher.mods.alwaysmoreitems.network.s2c.RecipeSyncPacket;
import net.glasslauncher.mods.alwaysmoreitems.registry.AMIItemRegistry;
import net.glasslauncher.mods.alwaysmoreitems.registry.RecipeRegistry;
import net.glasslauncher.mods.alwaysmoreitems.util.AMIHelpers;
import net.glasslauncher.mods.alwaysmoreitems.util.AlwaysMoreItems;
import net.glasslauncher.mods.alwaysmoreitems.util.ModRegistry;
import net.mine_diver.unsafeevents.listener.EventListener;
import net.mine_diver.unsafeevents.listener.ListenerPriority;
import net.modificationstation.stationapi.api.event.mod.InitEvent;
import net.modificationstation.stationapi.api.event.network.packet.PacketRegisterEvent;
import net.modificationstation.stationapi.api.event.registry.RegistriesFrozenEvent;
import net.modificationstation.stationapi.api.mod.entrypoint.Entrypoint;
import net.modificationstation.stationapi.api.mod.entrypoint.EntrypointManager;
import net.modificationstation.stationapi.api.mod.entrypoint.EventBusPolicy;
import net.modificationstation.stationapi.api.util.Identifier;

@Entrypoint(eventBus=@EventBusPolicy(registerInstance=false))
public class CommonInit {
    private static ImmutableMap<Identifier, ModPluginProvider> plugins;
    private static ModRegistry modRegistry;

    @EventListener(priority=ListenerPriority.HIGHEST, phase="stationapi:pre_init")
    public static void preInit(InitEvent event) {
        AlwaysMoreItems.LOGGER.info("Hello");
        AlwaysMoreItems.setHelpers(new AMIHelpers());
        LinkedHashMap<Object, ModPluginProvider> pluginsMap = new LinkedHashMap<Object, ModPluginProvider>();
        FabricLoader.getInstance().getEntrypointContainers("alwaysmoreitems:plugin", ModPluginProvider.class).stream().map(EntrypointContainer::getEntrypoint).forEach(iModPlugin -> pluginsMap.put(iModPlugin.getId(), (ModPluginProvider)iModPlugin));
        LinkedHashMap oldPlugins = new LinkedHashMap(pluginsMap);
        pluginsMap.clear();
        pluginsMap.put(AlwaysMoreItems.NAMESPACE.id("vanilla"), (ModPluginProvider)oldPlugins.remove(AlwaysMoreItems.NAMESPACE.id("vanilla")));
        pluginsMap.putAll(oldPlugins);
        pluginsMap.values().forEach(iModPlugin -> {
            try {
                iModPlugin.onAMIHelpersAvailable(AlwaysMoreItems.getHelpers());
            }
            catch (RuntimeException e) {
                AlwaysMoreItems.LOGGER.error("Mod plugin failed: {}/{}", (Object)iModPlugin.getId(), iModPlugin.getClass(), (Object)e);
                pluginsMap.remove(iModPlugin.getId());
            }
        });
        plugins = ImmutableMap.copyOf(pluginsMap);
        FabricLoader.getInstance().getEntrypointContainers("alwaysmoreitems:action", Object.class).forEach(EntrypointManager::setup);
    }

    @EventListener
    public static void registerPackets(PacketRegisterEvent event) {
        ActionButtonPacket.register();
        GiveItemPacket.register();
        RecipeTransferPacket.register();
        RecipeSyncPacket.register();
    }

    @EventListener
    public static void initAMI(RegistriesFrozenEvent event) {
        AlwaysMoreItems.setStarted(true);
        AMIItemRegistry itemRegistry = new AMIItemRegistry();
        AlwaysMoreItems.setItemRegistry(itemRegistry);
        ImmutableMap<Identifier, ModPluginProvider> plugins = CommonInit.getPlugins();
        plugins.values().forEach(iModPlugin -> {
            try {
                iModPlugin.onItemRegistryAvailable(itemRegistry);
            }
            catch (RuntimeException e) {
                AlwaysMoreItems.LOGGER.error("Mod plugin failed: {}/{}", (Object)iModPlugin.getId(), iModPlugin.getClass(), (Object)e);
                plugins.remove((Object)iModPlugin.getId());
            }
        });
        modRegistry = new ModRegistry();
        plugins.values().forEach(iModPlugin -> {
            try {
                iModPlugin.register(modRegistry);
                AlwaysMoreItems.LOGGER.info("Registered plugin: {}/{}", (Object)iModPlugin.getId(), (Object)iModPlugin.getClass().getName());
            }
            catch (RuntimeException e) {
                AlwaysMoreItems.LOGGER.error("Mod plugin failed: {}/{}", (Object)iModPlugin.getId(), iModPlugin.getClass(), (Object)e);
                plugins.remove((Object)iModPlugin.getId());
            }
        });
        RecipeRegistry recipeRegistry = modRegistry.createRecipeRegistry();
        AlwaysMoreItems.setRecipeRegistry(recipeRegistry);
        plugins.values().forEach(iModPlugin -> {
            AlwaysMoreItems.LOGGER.info("Initializing plugin {}", (Object)iModPlugin.getName());
            try {
                iModPlugin.onRecipeRegistryAvailable(recipeRegistry);
            }
            catch (RuntimeException e) {
                AlwaysMoreItems.LOGGER.error("Mod plugin failed: {}/{}", (Object)iModPlugin.getId(), iModPlugin.getClass(), (Object)e);
                plugins.remove((Object)iModPlugin.getId());
            }
        });
    }

    public static ImmutableMap<Identifier, ModPluginProvider> getPlugins() {
        return plugins;
    }

    public static ModRegistry getModRegistry() {
        return modRegistry;
    }
}

