/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.glasslauncher.mods.alwaysmoreitems.api.recipe.RecipeCategory;
import net.glasslauncher.mods.alwaysmoreitems.api.recipe.RecipeHandler;
import net.glasslauncher.mods.alwaysmoreitems.api.recipe.transfer.RecipeTransferHandler;
import net.glasslauncher.mods.alwaysmoreitems.gui.RecipeClickableArea;
import net.glasslauncher.mods.alwaysmoreitems.plugins.ami.description.ItemDescriptionRecipe;
import net.glasslauncher.mods.alwaysmoreitems.registry.RecipeRegistry;
import net.glasslauncher.mods.alwaysmoreitems.util.AlwaysMoreItems;
import net.glasslauncher.mods.alwaysmoreitems.util.RecipeTransferRegistry;
import net.minecraft.class_293;
import net.minecraft.class_31;

public class ModRegistry
implements net.glasslauncher.mods.alwaysmoreitems.api.ModRegistry {
    private final List<RecipeCategory> recipeCategories;
    private final List<RecipeHandler> recipeHandlers;
    private final List<Object> recipes = new ArrayList<Object>();
    private final RecipeTransferRegistry recipeTransferRegistry;
    private final Map<Class<? extends class_293>, RecipeClickableArea> recipeClickableAreas;

    public ModRegistry() {
        this.recipeCategories = new ArrayList<RecipeCategory>();
        this.recipeHandlers = new ArrayList<RecipeHandler>();
        this.recipeTransferRegistry = new RecipeTransferRegistry();
        this.recipeClickableAreas = new HashMap<Class<? extends class_293>, RecipeClickableArea>();
    }

    public ModRegistry(ModRegistry oldRegistry) {
        this.recipeCategories = oldRegistry.recipeCategories;
        this.recipeHandlers = oldRegistry.recipeHandlers;
        this.recipeTransferRegistry = oldRegistry.recipeTransferRegistry;
        this.recipeClickableAreas = oldRegistry.recipeClickableAreas;
    }

    @Override
    public void addRecipeCategories(RecipeCategory ... recipeCategories) {
        Collections.addAll(this.recipeCategories, recipeCategories);
    }

    @Override
    public void addRecipeHandlers(RecipeHandler ... recipeHandlers) {
        Collections.addAll(this.recipeHandlers, recipeHandlers);
    }

    @Override
    public void addRecipes(List recipes) {
        if (recipes != null) {
            this.recipes.addAll(recipes);
        }
    }

    @Override
    public void addRecipeClickArea(@Nonnull Class<? extends class_293> guiClass, int xPos, int yPos, int width, int height, String ... recipeCategoryUids) {
        RecipeClickableArea recipeClickableArea = new RecipeClickableArea(yPos, yPos + height, xPos, xPos + width, recipeCategoryUids);
        this.recipeClickableAreas.put(guiClass, recipeClickableArea);
    }

    @Override
    public void addDescription(List<class_31> itemStacks, String ... descriptionKeys) {
        if (itemStacks == null || itemStacks.isEmpty()) {
            IllegalArgumentException e = new IllegalArgumentException();
            AlwaysMoreItems.LOGGER.error("Tried to add description with no itemStacks.", (Throwable)e);
            return;
        }
        if (descriptionKeys.length == 0) {
            IllegalArgumentException e = new IllegalArgumentException();
            AlwaysMoreItems.LOGGER.error("Tried to add an empty list of descriptionKeys for itemStacks {}.", itemStacks, (Object)e);
            return;
        }
        List<ItemDescriptionRecipe> recipes = ItemDescriptionRecipe.create(itemStacks, descriptionKeys);
        this.recipes.addAll(recipes);
    }

    @Override
    public void addDescription(class_31 itemStack, String ... descriptionKeys) {
        this.addDescription(Collections.singletonList(itemStack), descriptionKeys);
    }

    @Override
    public net.glasslauncher.mods.alwaysmoreitems.api.recipe.transfer.RecipeTransferRegistry getRecipeTransferRegistry() {
        return this.recipeTransferRegistry;
    }

    @Nonnull
    public RecipeRegistry createRecipeRegistry() {
        List<RecipeTransferHandler> recipeTransferHandlers = this.recipeTransferRegistry.getRecipeTransferHandlers();
        return new RecipeRegistry(this.recipeCategories, this.recipeHandlers, recipeTransferHandlers, this.recipes, this.recipeClickableAreas);
    }
}

