/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.network.c2s;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.glasslauncher.mods.alwaysmoreitems.network.NetworkHelper;
import net.glasslauncher.mods.alwaysmoreitems.util.AlwaysMoreItems;
import net.minecraft.class_11;
import net.minecraft.class_124;
import net.minecraft.class_169;
import net.minecraft.class_187;
import net.minecraft.class_240;
import net.minecraft.class_31;
import net.minecraft.class_8;
import net.minecraft.client.Minecraft;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.network.packet.IdentifiablePacket;
import net.modificationstation.stationapi.api.registry.ItemRegistry;
import net.modificationstation.stationapi.api.util.Formatting;
import net.modificationstation.stationapi.api.util.Identifier;

public class GiveItemPacket
extends class_169
implements IdentifiablePacket {
    private static final Identifier IDENTIFIER = AlwaysMoreItems.NAMESPACE.id("give_item");
    private static final String STATION_ID = StationAPI.NAMESPACE.id("id").toString();
    private class_8 itemNbt;
    private int dataLength;

    public GiveItemPacket() {
    }

    public GiveItemPacket(class_8 nbt) {
        this.itemNbt = nbt;
    }

    public void method_806(DataInputStream stream) {
        this.itemNbt = new class_8();
        this.itemNbt.method_630((DataInput)stream);
    }

    public void method_807(DataOutputStream stream) {
        this.dataLength = NetworkHelper.writeAndGetNbtLength((class_187)this.itemNbt, stream);
    }

    public void method_808(class_240 networkHandler) {
        try {
            this.handleServer(networkHandler);
        }
        catch (NoSuchMethodError ignored) {
            this.handleClient();
        }
    }

    @Environment(value=EnvType.SERVER)
    public void handleServer(class_240 networkHandler) {
        if (networkHandler instanceof class_11) {
            class_11 serverPlay = (class_11)networkHandler;
            String id = this.itemNbt.method_1031(STATION_ID);
            class_124 item = (class_124)ItemRegistry.INSTANCE.get(Identifier.of((String)id));
            if (item == null) {
                AlwaysMoreItems.LOGGER.warn("{} tried to give an invalid item with id {}", (Object)serverPlay.method_1410(), (Object)id);
                return;
            }
            if (!serverPlay.field_919.field_2842.method_584(serverPlay.field_920.field_528)) {
                serverPlay.field_920.method_490(Formatting.RED + "You need to be opped to do this action!");
                return;
            }
            class_31 itemStack = new class_31(this.itemNbt);
            itemStack.field_751 = Math.min(itemStack.field_751, itemStack.method_709());
            serverPlay.field_920.method_490("Gave " + itemStack.field_751 + " " + itemStack.method_694().method_469() + "@" + itemStack.method_722());
            serverPlay.field_920.field_519.method_671(itemStack);
            serverPlay.field_920.field_519.method_947();
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER && serverPlay.field_920.field_521 != null) {
                serverPlay.field_920.field_521.method_2075();
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void handleClient() {
        String id = this.itemNbt.method_1031(STATION_ID);
        class_124 item = (class_124)ItemRegistry.INSTANCE.get(Identifier.of((String)id));
        if (item == null) {
            AlwaysMoreItems.LOGGER.warn("Invalid item id {}", (Object)id);
            return;
        }
        class_31 itemStack = new class_31(this.itemNbt);
        itemStack.field_751 = Math.min(itemStack.field_751, itemStack.method_709());
        Minecraft.field_2791.field_2806.field_519.method_671(itemStack);
    }

    public int method_798() {
        return this.dataLength;
    }

    public Identifier getId() {
        return IDENTIFIER;
    }

    public static void register() {
        IdentifiablePacket.register((Identifier)IDENTIFIER, (boolean)false, (boolean)true, GiveItemPacket::new);
    }
}

