/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.recipe;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.glasslauncher.mods.alwaysmoreitems.api.gui.GuiItemStackGroup;
import net.glasslauncher.mods.alwaysmoreitems.util.AlwaysMoreItems;
import net.minecraft.class_31;

public class CraftingGridHelper
implements net.glasslauncher.mods.alwaysmoreitems.api.gui.CraftingGridHelper {
    private final int craftInputSlot1;
    private final int craftOutputSlot;

    public CraftingGridHelper(int craftInputSlot1, int craftOutputSlot) {
        this.craftInputSlot1 = craftInputSlot1;
        this.craftOutputSlot = craftOutputSlot;
    }

    @Override
    public void setInput(@Nonnull GuiItemStackGroup guiItemStacks, @Nonnull List input) {
        int width;
        int height;
        if (input.size() > 4) {
            height = 3;
            width = 3;
        } else if (input.size() > 1) {
            height = 2;
            width = 2;
        } else {
            height = 1;
            width = 1;
        }
        this.setInput(guiItemStacks, input, width, height);
    }

    @Override
    public void setInput(@Nonnull GuiItemStackGroup guiItemStacks, @Nonnull List input, int width, int height) {
        for (int i = 0; i < input.size(); ++i) {
            Object recipeItem = input.get(i);
            int index = i;
            if (input.size() != 9) {
                index = this.getCraftingIndex(i, width, height);
            }
            List<class_31> itemStacks = AlwaysMoreItems.getStackHelper().toItemStackList(recipeItem);
            this.setInput(guiItemStacks, index, itemStacks);
        }
    }

    private int getCraftingIndex(int i, int width, int height) {
        int index;
        if (width == 1) {
            index = height == 3 ? i * 3 + 1 : (height == 2 ? i * 3 + 4 : 4);
        } else if (height == 1) {
            index = i;
        } else if (width == 2) {
            index = i;
            if (i > 1) {
                ++index;
                if (i > 3) {
                    ++index;
                }
            }
        } else {
            index = height == 2 ? i : i;
        }
        return index;
    }

    @Override
    public void setOutput(@Nonnull GuiItemStackGroup guiItemStacks, @Nonnull List<class_31> output) {
        guiItemStacks.set(this.craftOutputSlot, (Collection<class_31>)output);
    }

    private void setInput(@Nonnull GuiItemStackGroup guiItemStacks, int inputIndex, @Nonnull Collection<class_31> input) {
        guiItemStacks.set(this.craftInputSlot1 + inputIndex, input);
    }
}

