package net.glasslauncher.mods.alwaysmoreitems.gui.screen;

import lombok.Getter;
import lombok.Setter;
import net.glasslauncher.mods.alwaysmoreitems.api.gui.AMIDrawable;
import net.glasslauncher.mods.alwaysmoreitems.api.recipe.RecipeCategory;
import net.glasslauncher.mods.alwaysmoreitems.gui.AMITextRenderer;
import net.glasslauncher.mods.alwaysmoreitems.gui.RecipeLayout;
import net.glasslauncher.mods.alwaysmoreitems.gui.Tooltip;
import net.glasslauncher.mods.alwaysmoreitems.gui.widget.ActionButtonWidget;
import net.glasslauncher.mods.alwaysmoreitems.gui.widget.RecipeTransferButton;
import net.glasslauncher.mods.alwaysmoreitems.init.KeybindListener;
import net.glasslauncher.mods.alwaysmoreitems.recipe.Focus;
import net.glasslauncher.mods.alwaysmoreitems.transfer.RecipeTransferUtil;
import net.glasslauncher.mods.alwaysmoreitems.util.HoverChecker;
import net.glasslauncher.mods.alwaysmoreitems.util.RecipeGuiLogic;
import net.glasslauncher.mods.alwaysmoreitems.util.StringUtil;
import net.minecraft.class_300;
import net.minecraft.class_32;
import net.minecraft.class_33;
import net.minecraft.class_35;
import net.minecraft.class_54;
import net.minecraft.class_564;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.awt.*;
import java.util.ArrayList;
import java.util.List;

public class RecipesGui extends class_32 {
    private static final int borderPadding = 8;
    private static final int textPadding = 5;
    @Getter @Setter
    private boolean active = false;

    public class_32 parent;

    private int titleHeight;
    private int headerHeight;
    private int buttonWidth;

    /* Internal logic for the gui, handles finding recipes */
    private final RecipeGuiLogic logic = new RecipeGuiLogic();

    /* List of RecipeLayout to display */
    @Nonnull
    private final List<RecipeLayout> recipeLayouts = new ArrayList<>();

    private String pageString;
    private String title;
    private String backgroundTexture;
    private HoverChecker titleHoverChecker;

    private ActionButtonWidget nextRecipeCategory;
    private ActionButtonWidget previousRecipeCategory;
    private ActionButtonWidget nextPage;
    private ActionButtonWidget previousPage;

	@Nullable
    private RecipeLayout hovered;

    private int guiLeft;
    private int guiTop;
    @Getter
    private int xSize;
    @Getter
    private int ySize;

    public RecipesGui() {
    }

    @Override
    public void method_119() {
        field_151 = Minecraft.field_2791;
        // Race condition go fucking lmao
        if (field_151.field_2816 == null) {
            return;
        }
        field_157 = new class_35(field_151);
        field_156 = field_151.field_2815;
        field_154.clear();

        xSize = 176;

        if (field_153 > 300) {
            ySize = 256;
            backgroundTexture = "/assets/alwaysmoreitems/stationapi/textures/gui/recipeBackgroundTall.png";
        } else {
            ySize = 166;
            backgroundTexture = "/assets/alwaysmoreitems/stationapi/textures/gui/recipeBackground.png";
        }

        field_152 = field_151.field_2816.field_152;
        field_153 = field_151.field_2816.field_153;

        guiLeft = (field_152 - xSize) / 2;
        guiTop = (field_153 - ySize) / 2;

        titleHeight = AMITextRenderer.FONT_HEIGHT + borderPadding;
        headerHeight = titleHeight + AMITextRenderer.FONT_HEIGHT + textPadding;

        buttonWidth = 13;

        int buttonHeight = AMITextRenderer.FONT_HEIGHT + 3;

        int rightButtonX = guiLeft + xSize - borderPadding - buttonWidth;
        int leftButtonX = guiLeft + borderPadding;

        int recipeClassButtonTop = guiTop + borderPadding - 2;
        nextRecipeCategory = new ActionButtonWidget(2, rightButtonX, recipeClassButtonTop, buttonWidth, buttonHeight, "gui.alwaysmoreitems.nextCharacter", "gui.alwaysmoreitems.nextCharacter");
        previousRecipeCategory = new ActionButtonWidget(3, leftButtonX, recipeClassButtonTop, buttonWidth, buttonHeight, "gui.alwaysmoreitems.previousCharacter", "gui.alwaysmoreitems.previousCharacter");

        int pageButtonTop = guiTop + titleHeight + 3;
        nextPage = new ActionButtonWidget(4, rightButtonX, pageButtonTop, buttonWidth, buttonHeight, "gui.alwaysmoreitems.nextCharacter", "gui.alwaysmoreitems.nextCharacter");
        previousPage = new ActionButtonWidget(5, leftButtonX, pageButtonTop, buttonWidth, buttonHeight, "gui.alwaysmoreitems.previousCharacter", "gui.alwaysmoreitems.previousCharacter");

        addButtons();

        updateLayout();
    }

    @SuppressWarnings("unchecked")
    private void addButtons() {
        field_154.add(nextRecipeCategory);
        field_154.add(previousRecipeCategory);
        field_154.add(nextPage);
        field_154.add(previousPage);
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return (mouseX >= guiLeft) && (mouseY >= guiTop) && (mouseX < guiLeft + xSize) && (mouseY < guiTop + ySize);
    }


    @Override
    public void method_124(int mouseX, int mouseY, int mouseButton) {
        if (!active) {
            return;
        }

        if (!isMouseOver(mouseX, mouseY)) {
            super.method_124(mouseX, mouseY, mouseButton);
            return;
        }

        for (RecipeLayout recipeLayout : recipeLayouts) {
            if (recipeLayout.handleClick(field_151, mouseX, mouseY, mouseButton)) {
                return;
            }
        }

        if (titleHoverChecker.isOver(mouseX, mouseY)) {
            boolean success = logic.setCategoryFocus();
            if (success) {
                updateLayout();
            } else {
                super.method_124(mouseX, mouseY, mouseButton);
            }
            return;
        }

        if (hovered != null) {
            if (mouseButton == 0) {
                Focus focus = hovered.getItemStacks().getFocusUnderMouse(mouseX - hovered.getPosX(), mouseY - hovered.getPosY());
                if (focus != null) {
                    showRecipes(focus);
                    return;
                }
            }
            if (mouseButton == 1) {
                Focus focus = hovered.getItemStacks().getFocusUnderMouse(mouseX - hovered.getPosX(), mouseY - hovered.getPosY());
                if (focus != null) {
                    showUses(focus);
                    return;
                }
            }
        }

        super.method_124(mouseX, mouseY, mouseButton);
    }

    public void handleMouseScrolled(int mouseX, int mouseY) {
        if (!isMouseOver(mouseX, mouseY)) {
            return;
        }

        int scrollDelta = Mouse.getDWheel();
        if (scrollDelta < 0) {
            logic.nextPage();
            updateLayout();
        }
        else if (scrollDelta > 0) {
            logic.previousPage();
            updateLayout();
        }
    }

    @Override
    public void method_131() {
        if (!active) {
            return;
        }

        super.method_131();
    }

    public void open(class_32 newParent) {
        if (newParent != this) {
            parent = newParent;
        }
        active = true;
        method_119();
    }

    public void close() {
        active = false;
    }

    public void showRecipes(@Nonnull Focus focus) {
        focus.setMode(Focus.Mode.OUTPUT);
        if (logic.setFocus(focus)) {
            updateLayout();
            open(Minecraft.field_2791.field_2816);
        }
    }

    public void showUses(@Nonnull Focus focus) {
        focus.setMode(Focus.Mode.INPUT);
        if (logic.setFocus(focus)) {
            updateLayout();
            open(Minecraft.field_2791.field_2816);
        }
    }

    public void showCategories(@Nonnull List<String> recipeCategoryUids) {
        if (logic.setCategoryFocus(recipeCategoryUids)) {
            updateLayout();
            open(Minecraft.field_2791.field_2816);
        }
    }

    public void back() {
        if (logic.back()) {
            updateLayout();
        }
    }

    @Override
    protected void method_120(@Nonnull class_33 guibutton) {
        boolean updateLayout = true;

        if (guibutton.field_1373 == nextPage.field_1373) {
            logic.nextPage();
        } else if (guibutton.field_1373 == previousPage.field_1373) {
            logic.previousPage();
        } else if (guibutton.field_1373 == nextRecipeCategory.field_1373) {
            logic.nextRecipeCategory();
        } else if (guibutton.field_1373 == previousRecipeCategory.field_1373) {
            logic.previousRecipeCategory();
        } else if (guibutton.field_1373 >= RecipeLayout.recipeTransferButtonIndex) {
            int recipeIndex = guibutton.field_1373 - RecipeLayout.recipeTransferButtonIndex;
            RecipeLayout recipeLayout = recipeLayouts.get(recipeIndex);
            boolean maxTransfer = Keyboard.isKeyDown(Keyboard.KEY_LSHIFT);
            if (RecipeTransferUtil.transferRecipe(recipeLayout, field_151.field_2806, maxTransfer)) {
                close();
                updateLayout = false;
            }
        } else {
            updateLayout = false;
        }

        if (updateLayout) {
            updateLayout();
        }
    }

    private void updateLayout() {
        RecipeCategory recipeCategory = logic.getRecipeCategory();
        if (recipeCategory == null) {
            return;
        }

        AMIDrawable recipeBackground = recipeCategory.getBackground();

        final int recipesPerPage = Math.max(1, (ySize - headerHeight) / (recipeBackground.getHeight() + borderPadding));
        final int recipeXOffset = (xSize - recipeBackground.getWidth()) / 2;
        final int recipeSpacing = (ySize - headerHeight - (recipesPerPage * recipeBackground.getHeight())) / (recipesPerPage + 1);

        logic.setRecipesPerPage(recipesPerPage);

        title = recipeCategory.getTitle();
        int titleWidth = field_156.method_1901(title);
        int titleX = guiLeft + (xSize - titleWidth) / 2;
        int titleY = guiTop + borderPadding;
        titleHoverChecker = new HoverChecker(titleY, titleY + AMITextRenderer.FONT_HEIGHT, titleX, titleX + titleWidth);

        int posX = guiLeft + recipeXOffset;
        int posY = guiTop + headerHeight + recipeSpacing;
        int spacingY = recipeBackground.getHeight() + recipeSpacing;

        recipeLayouts.clear();
        recipeLayouts.addAll(logic.getRecipeWidgets(posX, posY, spacingY));
        addRecipeTransferButtons(recipeLayouts);

        nextPage.field_1374 = previousPage.field_1374 = logic.hasMultiplePages();
        nextRecipeCategory.field_1374 = previousRecipeCategory.field_1374 = logic.hasMultipleCategories();

        pageString = logic.getPageString();
    }

    private void addRecipeTransferButtons(List<RecipeLayout> recipeLayouts) {
        field_154.clear();
        addButtons();

        class_54 player = Minecraft.field_2791.field_2806;

        for (RecipeLayout recipeLayout : recipeLayouts) {
            RecipeTransferButton button = recipeLayout.getRecipeTransferButton();
            button.init(recipeLayout, player);
            field_154.add(button);
        }
    }

    @Override
    public void method_122() {
        if (!active) {
            return;
        }

        super.method_122();
    }

    @Override
    public void method_118(int mouseX, int mouseY, float delta) {
        if (!active) {
            return;
        }

        handleMouseScrolled(mouseX, mouseY);

        Minecraft minecraft = Minecraft.field_2791;

        nextRecipeCategory.method_1186(minecraft, mouseX, mouseY);
        previousRecipeCategory.method_1186(minecraft, mouseX, mouseY);

        nextPage.method_1186(minecraft, mouseX, mouseY);
        previousPage.method_1186(minecraft, mouseX, mouseY);
        GL11.glDisable(GL11.GL_BLEND);

        GL11.glPushMatrix();
        GL11.glTranslatef(guiLeft, guiTop, 0.0F);

        method_1932(borderPadding + buttonWidth, borderPadding - 2, xSize - borderPadding - buttonWidth, borderPadding + 10, 0x30000000);
        method_1932(borderPadding + buttonWidth, titleHeight + textPadding - 2, xSize - borderPadding - buttonWidth, titleHeight + textPadding + 10, 0x30000000);

        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);

        StringUtil.drawCenteredString(field_156, title, xSize, borderPadding, Color.WHITE.getRGB(), true);
        StringUtil.drawCenteredString(field_156, pageString, xSize, titleHeight + textPadding, Color.WHITE.getRGB(), true);
        GL11.glPopMatrix();

        hovered = null;
        for (RecipeLayout recipeWidget : recipeLayouts) {
            if (recipeWidget.getFocusUnderMouse(mouseX, mouseY) != null) {
                hovered = recipeWidget;
            } else {
                recipeWidget.draw(minecraft, mouseX, mouseY);
            }
        }
    }

    public void drawHovered(int mouseX, int mouseY) {
        if (!active) {
            return;
        }
        if (hovered != null) {
            hovered.draw(field_151, mouseX, mouseY);
        }
        if (titleHoverChecker.isOver(mouseX, mouseY)) {
            Focus focus = logic.getFocus();
            if (focus != null && !focus.isBlank()) {
                Tooltip.INSTANCE.setTooltip(new ArrayList<>(){{add(class_300.method_992().method_993("alwaysmoreitems.tooltip.show.all.recipes"));}}, mouseX, mouseY);
            }
        }
    }

    public void drawBackground() {
        method_134();

        bindTexture(backgroundTexture);

        method_1936(guiLeft, guiTop, 0, 0, xSize, ySize);
    }

    private void bindTexture(String texturePath) {
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        Minecraft.field_2791.field_2814.method_1097(Minecraft.field_2791.field_2814.method_1100(texturePath));
    }

    protected boolean recipeKeyPressed(int keyCode) {
        if (!active) {
            return false;
        }

        class_564 screenScaler = new class_564(Minecraft.field_2791.field_2824, Minecraft.field_2791.field_2802, Minecraft.field_2791.field_2803);
        int scaledWidth = screenScaler.method_1857();
        int scaledHeight = screenScaler.method_1858();
        int mouseX = Mouse.getX() * scaledWidth / Minecraft.field_2791.field_2802;
        int mouseY = scaledHeight - Mouse.getY() * scaledHeight / Minecraft.field_2791.field_2803 - 1;

        if (keyCode == Keyboard.KEY_ESCAPE || keyCode == field_151.field_2824.field_1473.field_2381) {
            close();
            return true;
        }

        if (hovered != null) {
            if (KeybindListener.showRecipe.field_2381 == keyCode) {
                Focus focus = hovered.getItemStacks().getFocusUnderMouse(mouseX - hovered.getPosX(), mouseY - hovered.getPosY());
                if (focus != null) {
                    showRecipes(focus);
                    return true;
                }
            }
            if (KeybindListener.showUses.field_2381 == keyCode) {
                Focus focus = hovered.getItemStacks().getFocusUnderMouse(mouseX - hovered.getPosX(), mouseY - hovered.getPosY());
                if (focus != null) {
                    showUses(focus);
                    return true;
                }
            }
        }
        return false;
    }
}
