package net.glasslauncher.mods.alwaysmoreitems.gui.widget;

import net.glasslauncher.mods.alwaysmoreitems.api.recipe.transfer.RecipeTransferError;
import net.glasslauncher.mods.alwaysmoreitems.gui.RecipeLayout;
import net.glasslauncher.mods.alwaysmoreitems.gui.Tooltip;
import net.glasslauncher.mods.alwaysmoreitems.transfer.RecipeTransferUtil;
import net.minecraft.class_300;
import net.minecraft.class_54;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Keyboard;

import java.util.ArrayList;

public class RecipeTransferButton extends ActionButtonWidget {
	private static final String transferTooltip = class_300.method_992().method_993("alwaysmoreitems.tooltip.transfer");
	private static final String transferMaxTooltip = class_300.method_992().method_993("alwaysmoreitems.tooltip.transfer.max");
	private RecipeLayout recipeLayout;
	private RecipeTransferError recipeTransferError;

	public RecipeTransferButton(int id, int xPos, int yPos, int width, int height, String displayString) {
		super(id, xPos, yPos, width, height, displayString, displayString);
	}

	public void init(RecipeLayout recipeLayout, class_54 player) {
		this.recipeLayout = recipeLayout;
		this.recipeTransferError = RecipeTransferUtil.getTransferRecipeError(recipeLayout, player);

		if (this.recipeTransferError == null) {
			this.field_1374 = true;
			this.field_1375 = true;
		} else {
			this.field_1374 = false;
			RecipeTransferError.Type type = this.recipeTransferError.getType();
			this.field_1375 = (type == RecipeTransferError.Type.PLAYER);
		}
	}

	@Override
	public void method_1186(Minecraft mc, int mouseX, int mouseY) {
		super.method_1186(mc, mouseX, mouseY);
		if (mouseX >= this.field_1370 && mouseY >= this.field_1371 && mouseX < this.field_1370 + this.field_1368 && mouseY < this.field_1371 + this.field_1369 && field_1375) {
			if (recipeTransferError != null) {
				recipeTransferError.showError(mc, mouseX, mouseY, 0, 0, recipeLayout);
			} else {
				Tooltip.INSTANCE.setTooltip(new ArrayList<>(){{add(Keyboard.isKeyDown(Keyboard.KEY_LSHIFT) ? transferMaxTooltip : transferTooltip);}}, mouseX, mouseY);
			}
		}
	}
}
