package net.glasslauncher.mods.alwaysmoreitems.plugins.ami;

import net.glasslauncher.mods.alwaysmoreitems.api.*;
import net.glasslauncher.mods.alwaysmoreitems.plugins.ami.description.ItemDescriptionRecipe;
import net.glasslauncher.mods.alwaysmoreitems.plugins.ami.description.ItemDescriptionRecipeCategory;
import net.glasslauncher.mods.alwaysmoreitems.plugins.ami.description.ItemDescriptionRecipeHandler;
import net.glasslauncher.mods.alwaysmoreitems.plugins.vanilla.VanillaPlugin;
import net.glasslauncher.mods.alwaysmoreitems.util.AlwaysMoreItems;
import net.minecraft.class_202;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.util.Identifier;

import java.util.ArrayList;
import java.util.Arrays;

public class AMIPlugin implements ModPluginProvider {
	public static final Identifier ID = AlwaysMoreItems.NAMESPACE.id("always_more_items");

    @Override
	public String getName() {
		return "AMI";
	}

	@Override
	public Identifier getId() {
		return ID;
	}

	@Override
	public void onAMIHelpersAvailable(AMIHelpers amiHelpers) {
    }

	@Override
	public void onItemRegistryAvailable(ItemRegistry itemRegistry) {

	}

	@Override
	public void register(ModRegistry registry) {

		registry.addRecipeCategories(
				new ItemDescriptionRecipeCategory()
		);

		registry.addRecipeHandlers(
				new ItemDescriptionRecipeHandler()
		);
	}

	@Override
	public void onRecipeRegistryAvailable(RecipeRegistry recipeRegistry) {

	}

	@Override
	public SyncableRecipe deserializeRecipe(class_8 recipe) {
		return (SyncableRecipe) new ItemDescriptionRecipe(Arrays.asList(VanillaPlugin.parseInputs(recipe.method_1034("output"))), nbtListToArrayList(recipe.method_1034("description")));
	}

	public static <T> ArrayList<T> nbtListToArrayList(class_202 nbtList) {
		ArrayList<T> arrayList = new ArrayList<>(nbtList.method_1398());
		for (int i = 0; i < nbtList.method_1398(); i++) {
            //noinspection unchecked Good. Crash.
            arrayList.add((T) nbtList.method_1396(i));
		}
		return arrayList;
	}
}
