package net.glasslauncher.mods.alwaysmoreitems.util;

import net.minecraft.class_300;
import net.minecraft.class_31;
import net.modificationstation.stationapi.api.registry.ItemRegistry;
import net.modificationstation.stationapi.api.util.Identifier;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Locale;

/**
 * For getting properties of ItemStacks efficiently
 */
public class ItemStackElement {
	@Nonnull
	private final class_31 itemStack;
	@Nonnull
	private final String searchString;
	@Nonnull
	private final String modName;

	@Nullable
	public static ItemStackElement create(@Nonnull class_31 itemStack) {
		try {
			return new ItemStackElement(itemStack);
		} catch (RuntimeException e) {
			AlwaysMoreItems.LOGGER.warn("Found broken itemStack.", e);
			return null;
		}
	}

	private ItemStackElement(@Nonnull class_31 itemStack) {
		this.itemStack = itemStack;

		Identifier itemResourceLocation = ItemRegistry.INSTANCE.getId(itemStack.method_694());
		if (itemResourceLocation == null) {
			throw new NullPointerException("Null item id for #" + itemStack.method_694().field_461);
		}
		String modId = itemResourceLocation.getNamespace().toString().toLowerCase(Locale.ENGLISH);

		String modName = itemResourceLocation.getNamespace().getName().toLowerCase(Locale.ENGLISH);

		String displayName = class_300.method_992().method_995(itemStack.method_726());
		if (displayName == null) {
			throw new NullPointerException("No display name for item. " + itemResourceLocation + ' ' + itemStack.method_694().getClass());
		}

		String searchString = displayName.toLowerCase();

		this.modName = modId + ' ' + modName;

//		if (Config.isAtPrefixRequiredForModName()) {
			this.searchString = searchString;
//		} else {
//			this.searchString = searchString + ' ' + this.modName;
//		}
	}

	@Nonnull
	public class_31 getItemStack() {
		return itemStack;
	}

	@Nonnull
	public String getSearchString() {
		return searchString;
	}

	@Nonnull
	public String getModName() {
		return modName;
	}
}
