package net.glasslauncher.mods.alwaysmoreitems.action;

import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.glasslauncher.mods.alwaysmoreitems.api.action.ActionButton;
import net.minecraft.class_18;
import net.minecraft.class_54;
import net.minecraft.class_69;

public class TrashActionButton implements ActionButton {
    @Override
    public boolean perform(Object minecraft, class_18 world, class_54 player, boolean isOperator, int mouseButton, boolean holdingShift) {
        // If player inventory is null for some reason, return
        if(player.field_519 == null){
            return false;
        }

        // If not LMB, return
        if(mouseButton != 0){
            return false;
        }

        // Delete the cursors stack
        player.field_519.method_677(null);

        // If Player is holding SHIFT and is opped, delete the inventory
        if (holdingShift && isOperator) {
            for (int i = 0; i < player.field_519.method_948(); i++) {
                player.field_519.method_950(i, null);
            }
        }

        // Mark the inventory dirty
        player.field_519.method_947();

        // If on server, send content updates to client
        if(FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER){
            if(player instanceof class_69 serverPlayer){
                if(serverPlayer.field_521 != null){
                    serverPlayer.field_521.method_2075();
                }
            }
        }
        return true;
    }

    @Override
    public String getTexture() {
        return null;
    }

    @Override
    public boolean dontAddToScreen() {
        return true;
    }

    @Override
    public boolean tooltipEnabled() {
        return false;
    }
}
