package net.glasslauncher.mods.alwaysmoreitems.api;

import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;
import net.minecraft.class_124;
import net.minecraft.class_31;

/**
 * The IItemRegistry is provided by AMI and has some useful functions related to items.
 */
public interface ItemRegistry {

    /**
     * Returns a list of all the Items registered.
     */
    @Nonnull
    ImmutableList<class_31> getItemList();

    /**
     * Returns a list of all the Items that can be used as fuel in a vanilla furnace.
     */
    @Nonnull
    ImmutableList<class_31> getFuels();

    /**
     * Returns a mod name for the given item.
     */
    @Nonnull
    String getModNameForItem(@Nonnull class_124 item);

    @Nonnull
    ImmutableList<class_31> getItemListForModId(@Nonnull String modId);
}
