package net.glasslauncher.mods.alwaysmoreitems.network.c2s;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.glasslauncher.mods.alwaysmoreitems.api.AMINbt;
import net.glasslauncher.mods.alwaysmoreitems.network.NetworkHelper;
import net.glasslauncher.mods.alwaysmoreitems.transfer.BasicRecipeTransferHandler;
import net.glasslauncher.mods.alwaysmoreitems.util.AlwaysMoreItems;
import net.minecraft.class_11;
import net.minecraft.class_169;
import net.minecraft.class_187;
import net.minecraft.class_240;
import net.minecraft.class_31;
import net.minecraft.class_54;
import net.minecraft.class_8;
import net.minecraft.client.Minecraft;
import net.modificationstation.stationapi.api.nbt.NbtIntArray;
import net.modificationstation.stationapi.api.network.packet.IdentifiablePacket;
import net.modificationstation.stationapi.api.util.Identifier;

import javax.annotation.Nonnull;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.*;

public class RecipeTransferPacket extends class_169 implements IdentifiablePacket {
    private static final Identifier IDENTIFIER = AlwaysMoreItems.NAMESPACE.id("transfer");

    private int outSize;

    private Map<Integer, class_31> recipeMap;
    private List<Integer> craftingSlots;
    private List<Integer> inventorySlots;
    private boolean maxTransfer;

    public RecipeTransferPacket() {

    }

    public RecipeTransferPacket(@Nonnull Map<Integer, class_31> recipeMap, @Nonnull List<Integer> craftingSlots, @Nonnull List<Integer> inventorySlots, boolean maxTransfer) {
        this.recipeMap = recipeMap;
        this.craftingSlots = craftingSlots;
        this.inventorySlots = inventorySlots;
        this.maxTransfer = maxTransfer;
    }

    @Override
    public Identifier getId() {
        return IDENTIFIER;
    }

    @Override
    public void method_806(DataInputStream buf) {
        class_8 data = new class_8();
        ((class_187) data).method_630(buf);

        class_8 nbtRecipeMap = data.method_1033("recipeMap");
        recipeMap = new HashMap<>();
        ((AMINbt) nbtRecipeMap).always_More_Items$entrySet().forEach(entry -> recipeMap.put(Integer.parseInt((String) entry.getKey()), new class_31((class_8) entry.getValue())));

        craftingSlots = new ArrayList<>();
        Arrays.stream(data.getIntArray("craftingSlots")).forEach(i -> craftingSlots.add(i));

        inventorySlots = new ArrayList<>();
        Arrays.stream(data.getIntArray("inventorySlots")).forEach(i -> inventorySlots.add(i));

        maxTransfer = data.method_1035("maxTransfer");
    }

    @Override
    public void method_807(DataOutputStream buf) {
        class_8 outData = new class_8();

        class_8 nbtRecipeMap = new class_8();
        recipeMap.forEach((key, value) -> {
            class_8 item = new class_8();
            value.method_706(item);
            nbtRecipeMap.method_1018(key.toString(), item);
        });
        outData.method_1018("recipeMap", nbtRecipeMap);

        outData.method_1017("craftingSlots", new NbtIntArray(craftingSlots.stream().mapToInt(Integer::intValue).toArray()));
        outData.method_1017("inventorySlots", new NbtIntArray(inventorySlots.stream().mapToInt(Integer::intValue).toArray()));

        outData.method_1021("maxTransfer", maxTransfer);

        outSize = NetworkHelper.writeAndGetNbtLength(outData, buf);
    }

    @Environment(EnvType.CLIENT)
    private class_54 getClientPlayer() {
        return Minecraft.field_2791.field_2806;
    }

    @Environment(EnvType.SERVER)
    private class_54 getServerPlayer(class_240 networkHandler) {
        return ((class_11) networkHandler).field_920;
    }

    @Override
    public void method_808(class_240 networkHandler) {
        class_54 player;
        if (FabricLoader.getInstance().getEnvironmentType().equals(EnvType.SERVER)) {
            player = getServerPlayer(networkHandler);
        }
        else {
            player = getClientPlayer();
        }
        BasicRecipeTransferHandler.setItems(player, recipeMap, craftingSlots, inventorySlots, maxTransfer);
    }

    @Override
    public int method_798() {
        return outSize;
    }

    public static void register() {
        IdentifiablePacket.register(IDENTIFIER, false, true, RecipeTransferPacket::new);
    }
}
