package net.glasslauncher.mods.alwaysmoreitems.plugins.vanilla.crafting;

import net.glasslauncher.mods.alwaysmoreitems.api.recipe.wrapper.ShapedCraftingRecipeWrapper;
import net.glasslauncher.mods.alwaysmoreitems.plugins.vanilla.VanillaRecipeWrapper;
import net.minecraft.class_31;
import net.modificationstation.stationapi.impl.recipe.StationShapedRecipe;

import javax.annotation.Nonnull;
import java.util.Arrays;
import java.util.List;

public class ShapedOreRecipeWrapper extends VanillaRecipeWrapper implements ShapedCraftingRecipeWrapper {

    @Nonnull
    private final StationShapedRecipe recipe;

    public ShapedOreRecipeWrapper(@Nonnull StationShapedRecipe recipe) {
        this.recipe = recipe;
        for (Object input : this.recipe.getIngredients()) {
            if (input instanceof class_31) {
                class_31 itemStack = (class_31) input;
                if (itemStack.field_751 != 1) {
                    itemStack.field_751 = 1;
                }
            }
        }
    }

    @Nonnull
    @Override
    public List getInputs() {
        return Arrays.asList(recipe.getIngredients());
    }

    @Nonnull
    @Override
    public List<class_31> getOutputs() {
        return List.of(recipe.getOutputs());
    }

    @Override
    public int getWidth() {
        return recipe.width;
    }

    @Override
    public int getHeight() {
        return recipe.height;
    }

}
