package net.glasslauncher.mods.alwaysmoreitems.plugins.vanilla.furnace;

import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.glasslauncher.mods.alwaysmoreitems.api.SyncableRecipe;
import net.glasslauncher.mods.alwaysmoreitems.api.gui.AnimatedDrawable;
import net.glasslauncher.mods.alwaysmoreitems.api.gui.StaticDrawable;
import net.glasslauncher.mods.alwaysmoreitems.gui.AMITextRenderer;
import net.glasslauncher.mods.alwaysmoreitems.gui.DrawableHelper;
import net.glasslauncher.mods.alwaysmoreitems.plugins.vanilla.VanillaPlugin;
import net.glasslauncher.mods.alwaysmoreitems.plugins.vanilla.VanillaRecipeWrapper;
import net.glasslauncher.mods.alwaysmoreitems.util.HoverChecker;
import net.minecraft.class_202;
import net.minecraft.class_300;
import net.minecraft.class_31;
import net.minecraft.class_8;
import net.minecraft.client.Minecraft;
import net.modificationstation.stationapi.api.util.Identifier;

import javax.annotation.Nonnull;
import java.awt.*;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class FuelRecipe extends VanillaRecipeWrapper implements SyncableRecipe {
    public static final DecimalFormat NUMBER_FORMAT = new DecimalFormat("0.##");
    @Nonnull
    private final List<List<class_31>> inputs;
    @Nonnull
    private final String burnTimeStringTicks;
    @Nonnull
    private final String burnTimeStringItems;
    @Nonnull
    private final String burnTimeStringSeconds;
    private final String burnTimeStringItemsFull;
    private final String burnTimeStringSecondsFull;
    private final int burnTimeStringItemsWidth;
    private final HoverChecker burnTimeStringItemsTooltipChecker;
    private final HoverChecker burnTimeStringSecondsTooltipChecker;
    @Nonnull
    private final AnimatedDrawable flame;
    private final int burnTime;

    public FuelRecipe(@Nonnull Collection<class_31> input, int burnTime) {
        List<class_31> inputList = new ArrayList<>(input);
        inputs = Collections.singletonList(inputList);
        this.burnTime = burnTime;
        if (FabricLoader.getInstance().getEnvironmentType().equals(EnvType.CLIENT)) {
            burnTimeStringTicks = class_300.method_992().method_994("gui.alwaysmoreitems.category.fuel.burnTime", burnTime);
            burnTimeStringItems = class_300.method_992().method_994("gui.alwaysmoreitems.category.fuel.burnTime.items", NUMBER_FORMAT.format(burnTime / 200f));
            burnTimeStringSeconds = class_300.method_992().method_994("gui.alwaysmoreitems.category.fuel.burnTime.seconds", NUMBER_FORMAT.format(burnTime / 20f));
            burnTimeStringItemsFull = class_300.method_992().method_993("gui.alwaysmoreitems.category.fuel.burnTime.items.full");
            burnTimeStringSecondsFull = class_300.method_992().method_993("gui.alwaysmoreitems.category.fuel.burnTime.seconds.full");
            burnTimeStringItemsWidth = AMITextRenderer.INSTANCE.method_1901(burnTimeStringItems);
            burnTimeStringItemsTooltipChecker = new HoverChecker(26, 35, 24, 24 + burnTimeStringItemsWidth);
            burnTimeStringSecondsTooltipChecker = new HoverChecker(26, 35, 24 + burnTimeStringItemsWidth + 8, 24 + burnTimeStringItemsWidth + AMITextRenderer.INSTANCE.method_1901(burnTimeStringSeconds) + 8);

            StaticDrawable flameDrawable = DrawableHelper.createDrawable("/gui/furnace.png", 176, 0, 14, 14);
            flame = DrawableHelper.createAnimatedDrawable(flameDrawable, burnTime, AnimatedDrawable.StartDirection.TOP, true);
        }
        else {
            flame = null;
            burnTimeStringTicks = null;
            burnTimeStringItems = null;
            burnTimeStringSeconds = null;
            burnTimeStringItemsFull = null;
            burnTimeStringSecondsFull = null;
            burnTimeStringItemsWidth = 0;
            burnTimeStringItemsTooltipChecker = null;
            burnTimeStringSecondsTooltipChecker = null;
        }
    }

    @Nonnull
    @Override
    public List<List<class_31>> getInputs() {
        return inputs;
    }

    @Override
    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        AMITextRenderer.INSTANCE.method_1906(burnTimeStringTicks, 24, 12, Color.DARK_GRAY.getRGB());
        AMITextRenderer.INSTANCE.method_1906(burnTimeStringItems, 24, 26, Color.GRAY.getRGB());
        AMITextRenderer.INSTANCE.method_1906(burnTimeStringSeconds, 24 + burnTimeStringItemsWidth + 8, 26, Color.GRAY.getRGB());
    }

    @Override
    public void drawAnimations(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight) {
        flame.draw(minecraft, 2, 0);
    }

    @Override
    public ArrayList<Object> getTooltip(int mouseX, int mouseY) {
        if(burnTimeStringItemsTooltipChecker.isOver(mouseX, mouseY)) {
            return new ArrayList<>(){{add(burnTimeStringItemsFull);}};
        }

        if (burnTimeStringSecondsTooltipChecker.isOver(mouseX, mouseY)) {
            return new ArrayList<>(){{add(burnTimeStringSecondsFull);}};
        }

        return null;
    }

    @Override
    public class_8 exportRecipe() {
        class_8 recipe = new class_8();
        class_202 items = new class_202();
        recipe.method_1017("input", items);
        for (class_31 itemStack : inputs.get(0)) {
            class_8 item = new class_8();
            itemStack.method_706(item);
            items.method_1397(item);
        }
        recipe.method_1015("burnTime", burnTime);
        recipe.method_1012("type", (byte) 6);
        return recipe;
    }

    @Override
    public Identifier getPlugin() {
        return VanillaPlugin.ID;
    }
}
