/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.config;

import java.io.File;
import net.fabricmc.loader.api.FabricLoader;
import net.glasslauncher.mods.alwaysmoreitems.config.AMIConfigObject;
import net.glasslauncher.mods.alwaysmoreitems.util.AlwaysMoreItems;
import net.glasslauncher.mods.gcapi3.api.ConfigRoot;
import net.glasslauncher.mods.gcapi3.api.GCAPI;
import net.glasslauncher.mods.gcapi3.impl.GlassYamlFile;
import net.minecraft.class_31;

public class AMIConfig {
    @ConfigRoot(value="config", visibleName="Main Config")
    public static final AMIConfigObject INSTANCE = new AMIConfigObject();

    public static boolean isRecipeAnimationsEnabled() {
        return true;
    }

    public static void addItemToConfigBlacklist(class_31 itemStack, boolean wildcard) {
        if (itemStack == null) {
            return;
        }
        String uid = AlwaysMoreItems.getStackHelper().getUniqueIdentifierForStack(itemStack, wildcard);
        if (AMIConfig.INSTANCE.itemBlacklist.add(uid)) {
            AMIConfig.updateBlacklist();
        }
    }

    public static void removeItemFromConfigBlacklist(class_31 itemStack, boolean wildcard) {
        if (itemStack == null) {
            return;
        }
        String uid = AlwaysMoreItems.getStackHelper().getUniqueIdentifierForStack(itemStack, wildcard);
        if (AMIConfig.INSTANCE.itemBlacklist.remove(uid)) {
            AMIConfig.updateBlacklist();
        }
    }

    public static boolean isItemOnConfigBlacklist(class_31 itemStack, boolean wildcard) {
        String uid = AlwaysMoreItems.getStackHelper().getUniqueIdentifierForStack(itemStack, wildcard);
        return AMIConfig.INSTANCE.itemBlacklist.contains(uid);
    }

    public static boolean isDebugModeEnabled() {
        return AMIConfig.INSTANCE.debugMode;
    }

    public static boolean isEditModeEnabled() {
        return AMIConfig.INSTANCE.editMode;
    }

    private static void updateBlacklist() {
        GCAPI.reloadConfig((String)AlwaysMoreItems.NAMESPACE.id("config").toString(), (GlassYamlFile)new GlassYamlFile(new File(FabricLoader.getInstance().getConfigDir().toFile(), AlwaysMoreItems.NAMESPACE + "/config.yml")));
        AlwaysMoreItems.LOGGER.info("Resetting item filter cache.");
        AlwaysMoreItems.getItemFilter().reset();
    }

    public static boolean showModNames() {
        return AMIConfig.INSTANCE.showModNames;
    }

    public static int getRightClickGiveAmount() {
        return AMIConfig.INSTANCE.rightClickGiveAmount;
    }

    public static boolean showNbtCount() {
        return AMIConfig.INSTANCE.showNbtCount;
    }

    public static boolean ignoreUntranslatedNames() {
        return AMIConfig.INSTANCE.ignoreUntranslatedNames;
    }

    public static boolean showRedundantItems() {
        return AMIConfig.INSTANCE.showRedundantItems;
    }
}

