/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.network.c2s;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.glasslauncher.mods.alwaysmoreitems.network.NetworkHelper;
import net.glasslauncher.mods.alwaysmoreitems.transfer.BasicRecipeTransferHandler;
import net.glasslauncher.mods.alwaysmoreitems.util.AlwaysMoreItems;
import net.minecraft.class_11;
import net.minecraft.class_169;
import net.minecraft.class_187;
import net.minecraft.class_240;
import net.minecraft.class_31;
import net.minecraft.class_54;
import net.minecraft.class_8;
import net.minecraft.client.Minecraft;
import net.modificationstation.stationapi.api.nbt.NbtIntArray;
import net.modificationstation.stationapi.api.network.packet.IdentifiablePacket;
import net.modificationstation.stationapi.api.util.Identifier;

public class RecipeTransferPacket
extends class_169
implements IdentifiablePacket {
    private static final Identifier IDENTIFIER = AlwaysMoreItems.NAMESPACE.id("transfer");
    private int outSize;
    private Map<Integer, class_31> recipeMap;
    private List<Integer> craftingSlots;
    private List<Integer> inventorySlots;
    private boolean maxTransfer;

    public RecipeTransferPacket() {
    }

    public RecipeTransferPacket(@Nonnull Map<Integer, class_31> recipeMap, @Nonnull List<Integer> craftingSlots, @Nonnull List<Integer> inventorySlots, boolean maxTransfer) {
        this.recipeMap = recipeMap;
        this.craftingSlots = craftingSlots;
        this.inventorySlots = inventorySlots;
        this.maxTransfer = maxTransfer;
    }

    public Identifier getId() {
        return IDENTIFIER;
    }

    public void method_806(DataInputStream buf) {
        class_8 data = new class_8();
        data.method_630((DataInput)buf);
        class_8 nbtRecipeMap = data.method_1033("recipeMap");
        this.recipeMap = new HashMap<Integer, class_31>();
        nbtRecipeMap.always_More_Items$entrySet().forEach(entry -> this.recipeMap.put(Integer.parseInt((String)entry.getKey()), new class_31((class_8)entry.getValue())));
        this.craftingSlots = new ArrayList<Integer>();
        Arrays.stream(data.getIntArray("craftingSlots")).forEach(i -> this.craftingSlots.add(i));
        this.inventorySlots = new ArrayList<Integer>();
        Arrays.stream(data.getIntArray("inventorySlots")).forEach(i -> this.inventorySlots.add(i));
        this.maxTransfer = data.method_1035("maxTransfer");
    }

    public void method_807(DataOutputStream buf) {
        class_8 outData = new class_8();
        class_8 nbtRecipeMap = new class_8();
        this.recipeMap.forEach((key, value) -> {
            class_8 item = new class_8();
            value.method_706(item);
            nbtRecipeMap.method_1018(key.toString(), item);
        });
        outData.method_1018("recipeMap", nbtRecipeMap);
        outData.method_1017("craftingSlots", (class_187)new NbtIntArray(this.craftingSlots.stream().mapToInt(Integer::intValue).toArray()));
        outData.method_1017("inventorySlots", (class_187)new NbtIntArray(this.inventorySlots.stream().mapToInt(Integer::intValue).toArray()));
        outData.method_1021("maxTransfer", this.maxTransfer);
        this.outSize = NetworkHelper.writeAndGetNbtLength((class_187)outData, buf);
    }

    @Environment(value=EnvType.CLIENT)
    private class_54 getClientPlayer() {
        return Minecraft.field_2791.field_2806;
    }

    @Environment(value=EnvType.SERVER)
    private class_54 getServerPlayer(class_240 networkHandler) {
        return ((class_11)networkHandler).field_920;
    }

    public void method_808(class_240 networkHandler) {
        class_54 player = FabricLoader.getInstance().getEnvironmentType().equals((Object)EnvType.SERVER) ? this.getServerPlayer(networkHandler) : this.getClientPlayer();
        BasicRecipeTransferHandler.setItems(player, this.recipeMap, this.craftingSlots, this.inventorySlots, this.maxTransfer);
    }

    public int method_798() {
        return this.outSize;
    }

    public static void register() {
        IdentifiablePacket.register((Identifier)IDENTIFIER, (boolean)false, (boolean)true, RecipeTransferPacket::new);
    }
}

