/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.util;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import net.glasslauncher.mods.alwaysmoreitems.gui.Tooltip;

public class ImageUtil {
    public static Tooltip.Dimension getImageDimension(File imgFile) throws IOException {
        int pos = imgFile.getName().lastIndexOf(".");
        if (pos == -1) {
            throw new IOException("No extension for file: " + imgFile.getAbsolutePath());
        }
        String suffix = imgFile.getName().substring(pos + 1);
        Iterator<ImageReader> iter = ImageIO.getImageReadersBySuffix(suffix);
        if (!iter.hasNext()) {
            throw new IOException("Not a known image file: " + imgFile.getAbsolutePath());
        }
        ImageReader reader = iter.next();
        try {
            FileImageInputStream stream = new FileImageInputStream(imgFile);
            reader.setInput(stream);
            int width = reader.getWidth(reader.getMinIndex());
            int height = reader.getHeight(reader.getMinIndex());
            reader.dispose();
            return new Tooltip.Dimension(width, height);
        }
        catch (IOException e) {
            reader.dispose();
            throw e;
        }
    }
}

