/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.glasslauncher.mods.alwaysmoreitems.util.AlwaysMoreItems;
import net.minecraft.class_124;
import net.modificationstation.stationapi.api.registry.ItemRegistry;
import net.modificationstation.stationapi.api.util.Identifier;
import org.apache.commons.lang3.text.WordUtils;

public class ModList {
    private final Map<String, String> modNamesForIds = new HashMap<String, String>();

    public ModList() {
        for (ModContainer modEntry : FabricLoader.getInstance().getAllMods()) {
            String lowercaseId = modEntry.getMetadata().getId().toLowerCase(Locale.ENGLISH);
            String modName = modEntry.getMetadata().getName();
            this.modNamesForIds.put(lowercaseId, modName);
        }
    }

    @Nonnull
    public String getModNameForItem(@Nonnull class_124 item) {
        Identifier itemResourceLocation = ItemRegistry.INSTANCE.getId((Object)item);
        if (itemResourceLocation == null) {
            AlwaysMoreItems.LOGGER.error("Null modId", (Throwable)new NullPointerException());
            return "";
        }
        String modId = itemResourceLocation.namespace.toString();
        String lowercaseModId = modId.toLowerCase(Locale.ENGLISH);
        String modName = this.modNamesForIds.get(lowercaseModId);
        if (modName == null) {
            modName = WordUtils.capitalize((String)modId);
            this.modNamesForIds.put(lowercaseModId, modName);
        }
        return modName;
    }
}

