/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.glasslauncher.mods.alwaysmoreitems.api.SubItemHelper;
import net.glasslauncher.mods.alwaysmoreitems.config.AMIConfig;
import net.glasslauncher.mods.alwaysmoreitems.gui.widget.ingredients.IGuiIngredient;
import net.glasslauncher.mods.alwaysmoreitems.util.AlwaysMoreItems;
import net.glasslauncher.mods.alwaysmoreitems.util.ItemUidException;
import net.minecraft.class_124;
import net.minecraft.class_133;
import net.minecraft.class_17;
import net.minecraft.class_31;
import net.minecraft.class_533;
import net.minecraft.class_629;
import net.minecraft.class_71;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.block.HasMetaNamedBlockItem;
import net.modificationstation.stationapi.api.block.MetaNamedBlockItemProvider;
import net.modificationstation.stationapi.api.registry.ItemRegistry;
import net.modificationstation.stationapi.api.util.Identifier;

public class StackHelper
implements net.glasslauncher.mods.alwaysmoreitems.api.recipe.StackHelper {
    @Nonnull
    public MatchingItemsResult getMatchingItems(@Nonnull List<class_31> availableItemStacks, @Nonnull Map<Integer, ? extends IGuiIngredient<class_31>> ingredientsMap) {
        MatchingItemsResult matchingItemResult = new MatchingItemsResult();
        int recipeSlotNumber = -1;
        TreeSet<Integer> keys = new TreeSet<Integer>(ingredientsMap.keySet());
        for (Integer key : keys) {
            IGuiIngredient<class_31> ingredient = ingredientsMap.get(key);
            if (!ingredient.isInput()) continue;
            ++recipeSlotNumber;
            List<class_31> requiredStacks = ingredient.getAll();
            if (requiredStacks.isEmpty()) continue;
            class_31 matching = this.containsStack(availableItemStacks, requiredStacks);
            if (matching == null) {
                matchingItemResult.missingItems.add(key);
                continue;
            }
            class_31 matchingSplit = matching.method_695(1);
            if (matching.field_751 == 0) {
                availableItemStacks.remove(matching);
            }
            matchingItemResult.matchingItems.put(recipeSlotNumber, matchingSplit);
        }
        return matchingItemResult;
    }

    @Nullable
    public class_133 getSlotWithStack(@Nonnull class_71 container, @Nonnull Iterable<Integer> slotNumbers, @Nonnull class_31 stack) {
        StackHelper stackHelper = AlwaysMoreItems.getStackHelper();
        for (Integer slotNumber : slotNumbers) {
            class_31 slotStack;
            class_133 slot = container.method_2084(slotNumber.intValue());
            if (slot == null || !stackHelper.isIdentical(stack, slotStack = slot.method_472())) continue;
            return slot;
        }
        return null;
    }

    @Nonnull
    public List<class_31> removeDuplicateItemStacks(@Nonnull Iterable<class_31> stacks) {
        ArrayList<class_31> newStacks = new ArrayList<class_31>();
        for (class_31 stack : stacks) {
            if (stack == null || this.containsStack(newStacks, stack) != null) continue;
            newStacks.add(stack);
        }
        return newStacks;
    }

    @Nullable
    public class_31 containsStack(@Nullable Iterable<class_31> stacks, @Nullable Iterable<class_31> contains) {
        if (stacks == null || contains == null) {
            return null;
        }
        for (class_31 containStack : contains) {
            class_31 matchingStack = this.containsStack(stacks, containStack);
            if (matchingStack == null) continue;
            return matchingStack;
        }
        return null;
    }

    @Nullable
    public class_31 containsStack(@Nullable Iterable<class_31> stacks, @Nullable class_31 contains) {
        if (stacks == null || contains == null) {
            return null;
        }
        for (class_31 stack : stacks) {
            if (!this.isIdentical(contains, stack)) continue;
            return stack;
        }
        return null;
    }

    public boolean isIdentical(@Nullable class_31 lhs, @Nullable class_31 rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        if (lhs.method_694() != rhs.method_694()) {
            return false;
        }
        if (lhs.method_722() != -1 && lhs.method_722() != rhs.method_722()) {
            return false;
        }
        return lhs.method_702(rhs);
    }

    @Override
    @Nonnull
    public List<class_31> getSubtypes(final @Nullable class_31 itemStack) {
        if (itemStack == null) {
            AlwaysMoreItems.LOGGER.error("Null itemStack", (Throwable)new NullPointerException());
            return Collections.emptyList();
        }
        class_124 item = itemStack.method_694();
        if (item == null) {
            AlwaysMoreItems.LOGGER.error("Null item in itemStack", (Throwable)new NullPointerException());
            return Collections.emptyList();
        }
        if (itemStack.method_722() != -1) {
            return new ArrayList<class_31>(){
                {
                    this.add(itemStack);
                }
            };
        }
        return this.getSubtypes(item, itemStack.field_751);
    }

    @Nonnull
    public List<class_31> getSubtypes(@Nonnull class_124 item, int stackSize) {
        List<class_31> subItems = SubItemHelper.getSubItems(item);
        if (subItems != null && !subItems.isEmpty()) {
            subItems = subItems.stream().peek(itemStack -> {
                itemStack.field_751 = stackSize;
            }).toList();
        } else {
            subItems = new ArrayList<class_31>();
            ArrayList<String> keyCache = new ArrayList<String>();
            if (FabricLoader.getInstance().getEnvironmentType().equals((Object)EnvType.SERVER)) {
                subItems.add(new class_31(item, stackSize, 0));
                return subItems;
            }
            if (item instanceof class_533) {
                class_533 blockItem = (class_533)item;
                class_17 class_172 = blockItem.getBlock();
                if (class_172 instanceof MetaNamedBlockItemProvider) {
                    MetaNamedBlockItemProvider metaBlockItemProvider = (MetaNamedBlockItemProvider)class_172;
                    for (int i = 0; i < metaBlockItemProvider.getValidMetas().length; ++i) {
                        subItems.add(new class_31(item, stackSize, metaBlockItemProvider.getValidMetas()[i]));
                    }
                    return subItems;
                }
                class_17 i = blockItem.getBlock();
                if (i instanceof HasMetaNamedBlockItem) {
                    HasMetaNamedBlockItem blockItemWithMeta = (HasMetaNamedBlockItem)i;
                    for (int i2 = 0; i2 < blockItemWithMeta.validMetas().length; ++i2) {
                        subItems.add(new class_31(item, stackSize, blockItemWithMeta.validMetas()[i2]));
                    }
                    return subItems;
                }
            }
            for (int meta = 0; meta < 16; ++meta) {
                try {
                    String translatedNameWithMeta;
                    class_31 itemStack2 = new class_31(item, stackSize, meta);
                    String translationKey = itemStack2.method_726();
                    if (keyCache.contains(translationKey)) continue;
                    if (translationKey.endsWith(String.valueOf(meta)) && translationKey.contains((translatedNameWithMeta = class_629.method_2049((String)(translationKey + ".name"))).substring(0, translatedNameWithMeta.length() - 5))) {
                        AlwaysMoreItems.LOGGER.debug("Untranslated meta value {} hidden, translation key is {}", (Object)meta, (Object)translationKey);
                        keyCache.add(translationKey);
                        continue;
                    }
                    if (itemStack2.method_694().method_469().equals(translationKey + ".name")) {
                        AlwaysMoreItems.LOGGER.debug("Item {} is not translated", (Object)translationKey);
                        if (AMIConfig.ignoreUntranslatedNames()) {
                            subItems.add(new class_31(item, stackSize, meta));
                            return subItems;
                        }
                    }
                    keyCache.add(translationKey);
                    subItems.add(itemStack2);
                    continue;
                }
                catch (Exception e) {
                    AlwaysMoreItems.LOGGER.error("An item being autoregistered threw an exception, yell at the creator of " + ItemRegistry.INSTANCE.getId(item.field_461).get(), (Throwable)e);
                }
            }
        }
        return subItems;
    }

    @Override
    @Nonnull
    public List<class_31> getAllSubtypes(@Nullable Iterable stacks) {
        if (stacks == null) {
            AlwaysMoreItems.LOGGER.error("Null stacks", (Throwable)new NullPointerException());
            return Collections.emptyList();
        }
        ArrayList<class_31> allSubtypes = new ArrayList<class_31>();
        this.getAllSubtypes(allSubtypes, stacks);
        return allSubtypes;
    }

    private void getAllSubtypes(@Nonnull List<class_31> subtypesList, @Nonnull Iterable stacks) {
        for (Object obj : stacks) {
            if (obj instanceof class_31) {
                class_31 itemStack = (class_31)obj;
                List<class_31> subtypes = this.getSubtypes(itemStack);
                subtypesList.addAll(subtypes);
                continue;
            }
            if (obj instanceof Iterable) {
                this.getAllSubtypes(subtypesList, (Iterable)obj);
                continue;
            }
            if (obj == null) continue;
            AlwaysMoreItems.LOGGER.error("Unknown object found: {}", obj);
        }
    }

    @Override
    @Nonnull
    public List<class_31> toItemStackList(@Nullable Object stacks) {
        if (stacks == null) {
            return Collections.emptyList();
        }
        ArrayList<class_31> itemStacksList = new ArrayList<class_31>();
        this.toItemStackList(itemStacksList, stacks);
        return this.removeDuplicateItemStacks(itemStacksList);
    }

    private void toItemStackList(@Nonnull List<class_31> itemStackList, @Nullable Object input) {
        if (input instanceof class_31) {
            itemStackList.add((class_31)input);
        } else if (!(input instanceof String)) {
            if (input instanceof Iterable) {
                for (Object obj : (Iterable)input) {
                    this.toItemStackList(itemStackList, obj);
                }
            } else if (input != null) {
                AlwaysMoreItems.LOGGER.error("Unknown object found: {}", input);
            }
        }
    }

    @Nonnull
    public String getUniqueIdentifierForStack(@Nonnull class_31 stack) {
        return this.getUniqueIdentifierForStack(stack, false);
    }

    @Nonnull
    public String getUniqueIdentifierForStack(@Nonnull class_31 stack, boolean wildcard) {
        class_124 item = stack.method_694();
        if (item == null) {
            throw new ItemUidException("Found an itemStack with a null item. This is an error from another mod.");
        }
        Identifier itemName = ItemRegistry.INSTANCE.getId((Object)item);
        if (itemName == null) {
            throw new ItemUidException("No name for item in GameData itemRegistry: " + item.getClass());
        }
        String itemNameString = itemName.toString();
        int metadata = stack.method_722();
        if (wildcard || metadata == -1) {
            return itemNameString;
        }
        StringBuilder itemKey = new StringBuilder(itemNameString);
        if (stack.method_719()) {
            class_8 nbtTagCompound;
            itemKey.append(':').append(metadata);
            if (!stack.getStationNbt().always_More_Items$hasNoTags() && (nbtTagCompound = AlwaysMoreItems.getHelpers().getNbtIgnoreList().getNbt(stack)) != null && !nbtTagCompound.always_More_Items$hasNoTags()) {
                itemKey.append(':').append(nbtTagCompound);
            }
        }
        return itemKey.toString();
    }

    @Nonnull
    public List<String> getUniqueIdentifiersWithWildcard(@Nonnull class_31 itemStack) {
        String uidWild;
        String uid = this.getUniqueIdentifierForStack(itemStack, false);
        if (uid.equals(uidWild = this.getUniqueIdentifierForStack(itemStack, true))) {
            return Collections.singletonList(uid);
        }
        return Arrays.asList(uid, uidWild);
    }

    public int addStack(@Nonnull class_71 container, @Nonnull Collection<Integer> slotIndexes, @Nonnull class_31 stack, boolean doAdd) {
        class_31 inventoryStack;
        class_133 slot;
        int added = 0;
        for (Integer slotIndex : slotIndexes) {
            slot = container.method_2084(slotIndex.intValue());
            if (slot == null || (inventoryStack = slot.method_472()) == null || inventoryStack.method_694() == null || !inventoryStack.method_715() || !inventoryStack.method_702(stack) || !class_31.method_703((class_31)inventoryStack, (class_31)stack)) continue;
            int remain = stack.field_751 - added;
            int space = inventoryStack.method_709() - inventoryStack.field_751;
            if (space <= 0) continue;
            if (space >= remain) {
                if (doAdd) {
                    inventoryStack.field_751 += remain;
                }
                return stack.field_751;
            }
            if (doAdd) {
                inventoryStack.field_751 = inventoryStack.method_709();
            }
            added += space;
        }
        if (added >= stack.field_751) {
            return added;
        }
        for (Integer slotIndex : slotIndexes) {
            slot = container.method_2084(slotIndex.intValue());
            if (slot == null || (inventoryStack = slot.method_472()) != null) continue;
            if (doAdd) {
                class_31 stackToAdd = stack.method_724();
                stackToAdd.field_751 = stack.field_751 - added;
                slot.method_479(stackToAdd);
            }
            return stack.field_751;
        }
        return added;
    }

    public static class MatchingItemsResult {
        @Nonnull
        public final Map<Integer, class_31> matchingItems = new HashMap<Integer, class_31>();
        @Nonnull
        public final List<Integer> missingItems = new ArrayList<Integer>();
    }
}

