/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.gui;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.glasslauncher.mods.alwaysmoreitems.api.gui.AMIDrawable;
import net.glasslauncher.mods.alwaysmoreitems.api.gui.AnimatedDrawable;
import net.glasslauncher.mods.alwaysmoreitems.api.gui.StaticDrawable;
import net.glasslauncher.mods.alwaysmoreitems.gui.widget.DrawableAnimated;
import net.glasslauncher.mods.alwaysmoreitems.gui.widget.DrawableBlank;
import net.glasslauncher.mods.alwaysmoreitems.gui.widget.DrawableResource;
import net.glasslauncher.mods.alwaysmoreitems.util.AlwaysMoreItems;
import net.glasslauncher.mods.alwaysmoreitems.util.TickTimer;

public class DrawableHelper {
    @Nonnull
    public static AnimatedDrawable createAnimatedDrawable(@Nullable StaticDrawable drawable, int ticksPerCycle, @Nullable AnimatedDrawable.StartDirection startDirection, boolean inverted) {
        if (drawable == null) {
            AlwaysMoreItems.LOGGER.error("Null drawable, returning blank drawable", (Throwable)new NullPointerException());
            return new DrawableBlank(0, 0);
        }
        if (startDirection == null) {
            AlwaysMoreItems.LOGGER.error("Null startDirection, defaulting to Top", (Throwable)new NullPointerException());
            startDirection = AnimatedDrawable.StartDirection.TOP;
        }
        if (inverted) {
            startDirection = startDirection == AnimatedDrawable.StartDirection.TOP ? AnimatedDrawable.StartDirection.BOTTOM : (startDirection == AnimatedDrawable.StartDirection.BOTTOM ? AnimatedDrawable.StartDirection.TOP : (startDirection == AnimatedDrawable.StartDirection.LEFT ? AnimatedDrawable.StartDirection.RIGHT : AnimatedDrawable.StartDirection.LEFT));
        }
        int tickTimerMaxValue = startDirection == AnimatedDrawable.StartDirection.TOP || startDirection == AnimatedDrawable.StartDirection.BOTTOM ? drawable.getHeight() : drawable.getWidth();
        TickTimer tickTimer = new TickTimer(ticksPerCycle, tickTimerMaxValue, !inverted);
        return new DrawableAnimated(drawable, tickTimer, startDirection);
    }

    @Nonnull
    public static StaticDrawable createDrawable(@Nullable String resourceLocation, int u, int v, int width, int height, int paddingTop, int paddingBottom, int paddingLeft, int paddingRight) {
        if (resourceLocation == null) {
            AlwaysMoreItems.LOGGER.error("Null resourceLocation, returning blank drawable", (Throwable)new NullPointerException());
            return new DrawableBlank(width, height);
        }
        return new DrawableResource(resourceLocation, u, v, width, height, paddingTop, paddingBottom, paddingLeft, paddingRight);
    }

    @Nonnull
    public static StaticDrawable createDrawable(@Nullable String resourceLocation, int u, int v, int width, int height) {
        if (resourceLocation == null) {
            AlwaysMoreItems.LOGGER.error("Null resourceLocation, returning blank drawable", (Throwable)new NullPointerException());
            return new DrawableBlank(width, height);
        }
        return new DrawableResource(resourceLocation, u, v, width, height);
    }

    public static AMIDrawable createBlankDrawable(int width, int height) {
        return new DrawableBlank(width, height);
    }
}

