/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.recipe;

import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.Weigher;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.glasslauncher.mods.alwaysmoreitems.api.ItemBlacklist;
import net.glasslauncher.mods.alwaysmoreitems.api.ItemRegistry;
import net.glasslauncher.mods.alwaysmoreitems.config.AMIConfig;
import net.glasslauncher.mods.alwaysmoreitems.util.AlwaysMoreItems;
import net.glasslauncher.mods.alwaysmoreitems.util.ItemStackElement;
import net.minecraft.class_124;
import net.minecraft.class_31;
import net.modificationstation.stationapi.api.util.Identifier;
import org.jetbrains.annotations.NotNull;

public class ItemFilter {
    @Nonnull
    private static String filterText = "";
    private final LoadingCache<String, ImmutableList<ItemStackElement>> filteredItemMapsCache;

    public ItemFilter(ItemRegistry itemRegistry) {
        this.filteredItemMapsCache = CacheBuilder.newBuilder().maximumWeight(16L).weigher((Weigher)new SearchFilterWeigher()).concurrencyLevel(1).build((CacheLoader)new ItemFilterCacheLoader(itemRegistry));
        this.filteredItemMapsCache.getUnchecked((Object)"");
    }

    public void reset() {
        this.filteredItemMapsCache.invalidateAll();
    }

    public static boolean setFilterText(@Nonnull String filterText) {
        String lowercaseFilterText = filterText.toLowerCase();
        if (ItemFilter.filterText.equals(lowercaseFilterText)) {
            return false;
        }
        ItemFilter.filterText = lowercaseFilterText;
        return true;
    }

    @Nonnull
    public String getFilterText() {
        return filterText;
    }

    @Nonnull
    public ImmutableList<ItemStackElement> getItemList() {
        String[] filters = filterText.split("\\|");
        if (filters.length == 1) {
            String filter = filters[0];
            return ImmutableList.copyOf((Collection)((ImmutableList)this.filteredItemMapsCache.getUnchecked((Object)filter)).stream().filter(itemStackElement -> AMIConfig.isEditModeEnabled() && !AlwaysMoreItems.getHelpers().getItemBlacklist().isItemAPIBlacklisted(itemStackElement.getItemStack()) || !AlwaysMoreItems.getHelpers().getItemBlacklist().isItemBlacklisted(itemStackElement.getItemStack())).collect(Collectors.toList()));
        }
        ImmutableList.Builder itemList = ImmutableList.builder();
        for (String filter : filters) {
            List<ItemStackElement> itemStackElements = ((ImmutableList)this.filteredItemMapsCache.getUnchecked((Object)filter)).stream().filter(itemStackElement -> AMIConfig.isEditModeEnabled() && !AlwaysMoreItems.getHelpers().getItemBlacklist().isItemAPIBlacklisted(itemStackElement.getItemStack()) || !AlwaysMoreItems.getHelpers().getItemBlacklist().isItemBlacklisted(itemStackElement.getItemStack())).toList();
            itemList.addAll(itemStackElements);
        }
        return itemList.build();
    }

    public int size() {
        return this.getItemList().size();
    }

    private static ImmutableList<ItemStackElement> createBaseList(ItemRegistry itemRegistry) {
        ItemStackChecker itemStackChecker = new ItemStackChecker();
        ImmutableList.Builder baseList = ImmutableList.builder();
        for (class_31 itemStack : itemRegistry.getItemList()) {
            ItemStackElement itemStackElement;
            if (itemStack == null || itemStackChecker.isItemHiddenByAPIBlacklist(itemStack) || (itemStackElement = ItemStackElement.create(itemStack)) == null) continue;
            baseList.add((Object)itemStackElement);
        }
        for (Multiset.Entry brokenItem : itemStackChecker.getBrokenItems().entrySet()) {
            int count = brokenItem.getCount();
            if (count <= 1) continue;
            class_124 item = (class_124)brokenItem.getElement();
            Identifier identifier = net.modificationstation.stationapi.api.registry.ItemRegistry.INSTANCE.getId((Object)item);
            if (identifier == null) {
                AlwaysMoreItems.LOGGER.error("Null modId", (Throwable)new NullPointerException());
                continue;
            }
            String modName = identifier.namespace.toString();
            AlwaysMoreItems.LOGGER.error("Couldn't get ItemModel for {} item {}. Suppressed {} similar errors.", (Object)modName, (Object)item, (Object)count);
        }
        return baseList.build();
    }

    private static class SearchFilterWeigher
    implements Weigher<String, ImmutableList<ItemStackElement>> {
        private SearchFilterWeigher() {
        }

        public int weigh(@Nonnull String key, @Nonnull ImmutableList<ItemStackElement> value) {
            return key.isEmpty() ? 0 : 1;
        }
    }

    private class ItemFilterCacheLoader
    extends CacheLoader<String, ImmutableList<ItemStackElement>> {
        private final ItemRegistry itemRegistry;

        public ItemFilterCacheLoader(ItemRegistry itemRegistry) {
            this.itemRegistry = itemRegistry;
        }

        @NotNull
        public ImmutableList<ItemStackElement> load(@Nonnull String filterText) throws Exception {
            if (filterText.isEmpty()) {
                return ItemFilter.createBaseList(this.itemRegistry);
            }
            String prevFilterText = filterText.substring(0, filterText.length() - 1);
            ImmutableList baseItemSet = (ImmutableList)ItemFilter.this.filteredItemMapsCache.get((Object)prevFilterText);
            FilterPredicate filterPredicate = new FilterPredicate(filterText);
            ImmutableList.Builder itemStackElementsBuilder = ImmutableList.builder();
            for (ItemStackElement itemStackElement : baseItemSet) {
                if (!filterPredicate.apply(itemStackElement)) continue;
                itemStackElementsBuilder.add((Object)itemStackElement);
            }
            return itemStackElementsBuilder.build();
        }
    }

    private static class ItemStackChecker {
        private final ItemBlacklist itemBlacklist;
        private final Multiset<class_124> brokenItems = HashMultiset.create();

        public ItemStackChecker() {
            this.itemBlacklist = AlwaysMoreItems.getHelpers().getItemBlacklist();
        }

        public boolean isItemStackHidden(@Nonnull class_31 itemStack) {
            if (!(AMIConfig.isEditModeEnabled() || AMIConfig.isItemOnConfigBlacklist(itemStack, true) || AMIConfig.isItemOnConfigBlacklist(itemStack, false))) {
                return false;
            }
            return this.isItemHiddenByAPIBlacklist(itemStack);
        }

        private boolean isItemHiddenByAPIBlacklist(@Nonnull class_31 itemStack) {
            return this.itemBlacklist.isItemAPIBlacklisted(itemStack);
        }

        public Multiset<class_124> getBrokenItems() {
            return this.brokenItems;
        }
    }

    private static class FilterPredicate
    implements Predicate<ItemStackElement> {
        private final List<String> itemNameTokens = new ArrayList<String>();
        private final List<String> modNameTokens = new ArrayList<String>();

        public FilterPredicate(String filterText) {
            String[] tokens;
            for (String token : tokens = filterText.split(" ")) {
                if (token.startsWith("@")) {
                    String modNameToken = token.substring(1);
                    this.modNameTokens.add(modNameToken);
                    continue;
                }
                this.itemNameTokens.add(token);
            }
        }

        public boolean apply(@Nullable ItemStackElement input) {
            if (input == null) {
                return false;
            }
            String modName = input.getModName();
            for (String token : this.modNameTokens) {
                if (modName.contains(token)) continue;
                return false;
            }
            String itemName = input.getSearchString();
            for (String token : this.itemNameTokens) {
                if (itemName.contains(token)) continue;
                return false;
            }
            return true;
        }
    }
}

