/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.registry;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.glasslauncher.mods.alwaysmoreitems.api.ItemRegistry;
import net.glasslauncher.mods.alwaysmoreitems.util.AlwaysMoreItems;
import net.minecraft.class_124;
import net.minecraft.class_31;
import net.modificationstation.stationapi.api.recipe.FuelRegistry;
import net.modificationstation.stationapi.api.util.Identifier;

public class AMIItemRegistry
implements ItemRegistry {
    @Nonnull
    private final Set<String> itemNameSet = new HashSet<String>();
    @Nonnull
    private final ImmutableList<class_31> itemList;
    @Nonnull
    private final ImmutableListMultimap<String, class_31> itemsByModId;
    @Nonnull
    private final ImmutableList<class_31> fuels;

    public AMIItemRegistry() {
        class_124[] items;
        ArrayList<class_31> itemListMutable = new ArrayList<class_31>();
        ArrayList<class_31> fuelsMutable = new ArrayList<class_31>();
        for (class_124 item : items = (class_124[])net.modificationstation.stationapi.api.registry.ItemRegistry.INSTANCE.stream().toArray(class_124[]::new)) {
            this.addItemAndSubItems(item, itemListMutable, fuelsMutable);
        }
        this.itemList = ImmutableList.copyOf(itemListMutable);
        this.fuels = ImmutableList.copyOf(fuelsMutable);
        ImmutableListMultimap.Builder itemsByModIdBuilder = ImmutableListMultimap.builder();
        for (class_31 itemStack : itemListMutable) {
            class_124 item;
            item = itemStack.method_694();
            if (item == null) continue;
            Identifier itemResourceLocation = net.modificationstation.stationapi.api.registry.ItemRegistry.INSTANCE.getId((Object)itemStack.method_694());
            if (itemResourceLocation == null) {
                AlwaysMoreItems.LOGGER.warn("Item has no associated mod id", (Throwable)new NullPointerException());
                continue;
            }
            String modId = itemResourceLocation.namespace.toString().toLowerCase(Locale.ENGLISH);
            itemsByModIdBuilder.put((Object)modId, (Object)itemStack);
        }
        this.itemsByModId = itemsByModIdBuilder.build();
    }

    @Override
    @Nonnull
    public ImmutableList<class_31> getItemList() {
        return this.itemList;
    }

    @Override
    @Nonnull
    public ImmutableList<class_31> getFuels() {
        return this.fuels;
    }

    @Override
    @Nonnull
    public String getModNameForItem(@Nullable class_124 item) {
        Identifier identifier = net.modificationstation.stationapi.api.registry.ItemRegistry.INSTANCE.getId((Object)item);
        if (identifier == null) {
            AlwaysMoreItems.LOGGER.error("Item has no identifier?", (Throwable)new NullPointerException());
            return "";
        }
        Optional modContainer = FabricLoader.getInstance().getModContainer(identifier.namespace.toString());
        if (modContainer.isEmpty()) {
            AlwaysMoreItems.LOGGER.error("Mod namespace has no container", (Throwable)new NullPointerException());
            return "";
        }
        return ((ModContainer)modContainer.get()).getMetadata().getName();
    }

    @Override
    @Nonnull
    public ImmutableList<class_31> getItemListForModId(@Nullable String modId) {
        if (modId == null) {
            AlwaysMoreItems.LOGGER.error("Null modId", (Throwable)new NullPointerException());
            return ImmutableList.of();
        }
        String lowerCaseModId = modId.toLowerCase(Locale.ENGLISH);
        return this.itemsByModId.get((Object)lowerCaseModId);
    }

    private void addItemAndSubItems(@Nullable class_124 item, @Nonnull List<class_31> itemList, @Nonnull List<class_31> fuels) {
        if (item == null) {
            return;
        }
        List<class_31> items = AlwaysMoreItems.getStackHelper().getSubtypes(item, 1);
        this.addItemStacks(items, itemList, fuels);
    }

    private void addItemStacks(@Nonnull Iterable<class_31> stacks, @Nonnull List<class_31> itemList, @Nonnull List<class_31> fuels) {
        for (class_31 stack : stacks) {
            if (stack == null) continue;
            this.addItemStack(stack, itemList, fuels);
        }
    }

    private void addItemStack(@Nonnull class_31 stack, @Nonnull List<class_31> itemList, @Nonnull List<class_31> fuels) {
        try {
            String itemKey = AlwaysMoreItems.getStackHelper().getUniqueIdentifierForStack(stack);
            if (this.itemNameSet.contains(itemKey)) {
                return;
            }
            this.itemNameSet.add(itemKey);
            itemList.add(stack);
            if (FuelRegistry.getFuelTime((class_31)stack) > 0) {
                fuels.add(stack);
            }
        }
        catch (RuntimeException e) {
            AlwaysMoreItems.LOGGER.error("Couldn't create unique name for itemStack {}.", stack.getClass(), (Object)e);
        }
    }
}

