/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.util;

import net.glasslauncher.mods.alwaysmoreitems.util.MathUtil;
import net.minecraft.client.Minecraft;

public class TickTimer
implements net.glasslauncher.mods.alwaysmoreitems.api.gui.TickTimer {
    private final int ticksPerCycle;
    private final int maxValue;
    private final boolean countDown;
    private long lastUpdateWorldTime = 0L;
    private int tickCount = 0;

    public TickTimer(int ticksPerCycle, int maxValue, boolean countDown) {
        this.ticksPerCycle = ticksPerCycle;
        this.maxValue = maxValue;
        this.countDown = countDown;
    }

    @Override
    public int getValue() {
        long worldTime = Minecraft.field_2791.field_2804.method_256();
        long ticksPassed = worldTime - this.lastUpdateWorldTime;
        this.lastUpdateWorldTime = worldTime;
        this.tickCount += (int)ticksPassed;
        if (this.tickCount > this.ticksPerCycle) {
            this.tickCount = 0;
        }
        int value = MathUtil.divideCeil(this.tickCount * this.maxValue, this.ticksPerCycle);
        if (this.countDown) {
            return this.maxValue - value;
        }
        return value;
    }

    @Override
    public int getMaxValue() {
        return this.maxValue;
    }
}

