package net.glasslauncher.mods.alwaysmoreitems.network.c2s;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.glasslauncher.mods.alwaysmoreitems.action.ActionButtonRegistry;
import net.glasslauncher.mods.alwaysmoreitems.api.action.ActionButton;
import net.glasslauncher.mods.alwaysmoreitems.util.AlwaysMoreItems;
import net.minecraft.class_11;
import net.minecraft.class_169;
import net.minecraft.class_240;
import net.modificationstation.stationapi.api.network.packet.IdentifiablePacket;
import net.modificationstation.stationapi.api.util.Identifier;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

@SuppressWarnings("CallToPrintStackTrace")
public class ActionButtonPacket extends class_169 implements IdentifiablePacket {
    private static final Identifier IDENTIFIER = AlwaysMoreItems.NAMESPACE.id("action_button");

    public Identifier actionIdentifier;
    public int mouseButton;
    boolean holdingShift;

    public ActionButtonPacket() {
    }

    public ActionButtonPacket(Identifier actionIdentifier, int mouseButton, boolean holdingShift) {
        this.actionIdentifier = actionIdentifier;
        this.mouseButton = mouseButton;
        this.holdingShift = holdingShift;
    }

    @Override
    public void method_806(DataInputStream stream) {
        try {
            mouseButton = stream.readInt();
            holdingShift = stream.readBoolean();
            actionIdentifier = Identifier.of(stream.readUTF());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void method_807(DataOutputStream stream) {
        try {
            stream.writeInt(mouseButton);
            stream.writeBoolean(holdingShift);
            stream.writeUTF(actionIdentifier.toString());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void method_808(class_240 networkHandler) {
        handleServer(networkHandler);
    }

    @Environment(EnvType.SERVER)
    public void handleServer(class_240 networkHandler) {
        if (networkHandler instanceof class_11 serverPlay) {
            ActionButton actionButton = ActionButtonRegistry.INSTANCE.get(actionIdentifier);
            if (actionButton != null) {
                actionButton.perform(
                        serverPlay.field_919,
                        serverPlay.field_920.field_1596,
                        serverPlay.field_920,
                        serverPlay.field_919.field_2842.method_584(serverPlay.field_920.field_528), // serverPlay.server.ops.contains(playername)
                        mouseButton,
                        holdingShift
                );
            } else {
                AlwaysMoreItems.LOGGER.warn("Player {} tried to execute invalid action {}", serverPlay.field_920.field_528, actionIdentifier);
            }
        }
    }

    @Override
    public int method_798() {
        return 5 + actionIdentifier.toString().length();
    }

    @Override
    public Identifier getId() {
        return IDENTIFIER;
    }

    public static void register() {
        IdentifiablePacket.register(IDENTIFIER, false, true, ActionButtonPacket::new);
    }
}
