/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.plugins.vanilla.furnace;

import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.glasslauncher.mods.alwaysmoreitems.api.SyncableRecipe;
import net.glasslauncher.mods.alwaysmoreitems.api.gui.AnimatedDrawable;
import net.glasslauncher.mods.alwaysmoreitems.api.gui.StaticDrawable;
import net.glasslauncher.mods.alwaysmoreitems.gui.AMITextRenderer;
import net.glasslauncher.mods.alwaysmoreitems.gui.DrawableHelper;
import net.glasslauncher.mods.alwaysmoreitems.plugins.vanilla.VanillaPlugin;
import net.glasslauncher.mods.alwaysmoreitems.plugins.vanilla.VanillaRecipeWrapper;
import net.glasslauncher.mods.alwaysmoreitems.util.HoverChecker;
import net.minecraft.class_187;
import net.minecraft.class_202;
import net.minecraft.class_300;
import net.minecraft.class_31;
import net.minecraft.class_8;
import net.minecraft.client.Minecraft;
import net.modificationstation.stationapi.api.util.Identifier;

public class FuelRecipe
extends VanillaRecipeWrapper
implements SyncableRecipe {
    public static final DecimalFormat NUMBER_FORMAT = new DecimalFormat("0.##");
    @Nonnull
    private final List<List<class_31>> inputs;
    @Nonnull
    private final String burnTimeStringTicks;
    @Nonnull
    private final String burnTimeStringItems;
    @Nonnull
    private final String burnTimeStringSeconds;
    private final String burnTimeStringItemsFull;
    private final String burnTimeStringSecondsFull;
    private final int burnTimeStringItemsWidth;
    private final HoverChecker burnTimeStringItemsTooltipChecker;
    private final HoverChecker burnTimeStringSecondsTooltipChecker;
    @Nonnull
    private final AnimatedDrawable flame;
    private final int burnTime;

    public FuelRecipe(@Nonnull Collection<class_31> input, int burnTime) {
        ArrayList<class_31> inputList = new ArrayList<class_31>(input);
        this.inputs = Collections.singletonList(inputList);
        this.burnTime = burnTime;
        if (FabricLoader.getInstance().getEnvironmentType().equals((Object)EnvType.CLIENT)) {
            this.burnTimeStringTicks = class_300.method_992().method_994("gui.alwaysmoreitems.category.fuel.burnTime", new Object[]{burnTime});
            this.burnTimeStringItems = class_300.method_992().method_994("gui.alwaysmoreitems.category.fuel.burnTime.items", new Object[]{NUMBER_FORMAT.format((float)burnTime / 200.0f)});
            this.burnTimeStringSeconds = class_300.method_992().method_994("gui.alwaysmoreitems.category.fuel.burnTime.seconds", new Object[]{NUMBER_FORMAT.format((float)burnTime / 20.0f)});
            this.burnTimeStringItemsFull = class_300.method_992().method_993("gui.alwaysmoreitems.category.fuel.burnTime.items.full");
            this.burnTimeStringSecondsFull = class_300.method_992().method_993("gui.alwaysmoreitems.category.fuel.burnTime.seconds.full");
            this.burnTimeStringItemsWidth = AMITextRenderer.INSTANCE.method_1901(this.burnTimeStringItems);
            this.burnTimeStringItemsTooltipChecker = new HoverChecker(26, 35, 24, 24 + this.burnTimeStringItemsWidth);
            this.burnTimeStringSecondsTooltipChecker = new HoverChecker(26, 35, 24 + this.burnTimeStringItemsWidth + 8, 24 + this.burnTimeStringItemsWidth + AMITextRenderer.INSTANCE.method_1901(this.burnTimeStringSeconds) + 8);
            StaticDrawable flameDrawable = DrawableHelper.createDrawable("/gui/furnace.png", 176, 0, 14, 14);
            this.flame = DrawableHelper.createAnimatedDrawable(flameDrawable, burnTime, AnimatedDrawable.StartDirection.TOP, true);
        } else {
            this.flame = null;
            this.burnTimeStringTicks = null;
            this.burnTimeStringItems = null;
            this.burnTimeStringSeconds = null;
            this.burnTimeStringItemsFull = null;
            this.burnTimeStringSecondsFull = null;
            this.burnTimeStringItemsWidth = 0;
            this.burnTimeStringItemsTooltipChecker = null;
            this.burnTimeStringSecondsTooltipChecker = null;
        }
    }

    @Nonnull
    public List<List<class_31>> getInputs() {
        return this.inputs;
    }

    @Override
    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        AMITextRenderer.INSTANCE.method_1906(this.burnTimeStringTicks, 24, 12, Color.DARK_GRAY.getRGB());
        AMITextRenderer.INSTANCE.method_1906(this.burnTimeStringItems, 24, 26, Color.GRAY.getRGB());
        AMITextRenderer.INSTANCE.method_1906(this.burnTimeStringSeconds, 24 + this.burnTimeStringItemsWidth + 8, 26, Color.GRAY.getRGB());
    }

    @Override
    public void drawAnimations(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight) {
        this.flame.draw(minecraft, 2, 0);
    }

    @Override
    public ArrayList<Object> getTooltip(int mouseX, int mouseY) {
        if (this.burnTimeStringItemsTooltipChecker.isOver(mouseX, mouseY)) {
            return new ArrayList<Object>(){
                {
                    this.add(FuelRecipe.this.burnTimeStringItemsFull);
                }
            };
        }
        if (this.burnTimeStringSecondsTooltipChecker.isOver(mouseX, mouseY)) {
            return new ArrayList<Object>(){
                {
                    this.add(FuelRecipe.this.burnTimeStringSecondsFull);
                }
            };
        }
        return null;
    }

    @Override
    public class_8 exportRecipe() {
        class_8 recipe = new class_8();
        class_202 items = new class_202();
        recipe.method_1017("input", (class_187)items);
        for (class_31 itemStack : this.inputs.get(0)) {
            class_8 item = new class_8();
            itemStack.method_706(item);
            items.method_1397((class_187)item);
        }
        recipe.method_1015("burnTime", this.burnTime);
        recipe.method_1012("type", (byte)6);
        return recipe;
    }

    @Override
    public Identifier getPlugin() {
        return VanillaPlugin.ID;
    }
}

