/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.glasslauncher.mods.alwaysmoreitems.api.SyncableRecipe;
import net.glasslauncher.mods.alwaysmoreitems.api.recipe.RecipeCategory;
import net.glasslauncher.mods.alwaysmoreitems.api.recipe.RecipeHandler;
import net.glasslauncher.mods.alwaysmoreitems.api.recipe.RecipeWrapper;
import net.glasslauncher.mods.alwaysmoreitems.api.recipe.transfer.RecipeTransferHandler;
import net.glasslauncher.mods.alwaysmoreitems.config.AMIConfig;
import net.glasslauncher.mods.alwaysmoreitems.gui.RecipeClickableArea;
import net.glasslauncher.mods.alwaysmoreitems.util.AlwaysMoreItems;
import net.glasslauncher.mods.alwaysmoreitems.util.ItemUidException;
import net.glasslauncher.mods.alwaysmoreitems.util.RecipeCategoryComparator;
import net.glasslauncher.mods.alwaysmoreitems.util.RecipeMap;
import net.minecraft.class_293;
import net.minecraft.class_31;
import net.minecraft.class_71;

public class RecipeRegistry
implements net.glasslauncher.mods.alwaysmoreitems.api.RecipeRegistry {
    private final ImmutableMap<Class, RecipeHandler> recipeHandlers;
    private final ImmutableTable<Class, String, RecipeTransferHandler> recipeTransferHandlers;
    private final ImmutableMap<Class<? extends class_293>, RecipeClickableArea> recipeClickableAreas;
    private final ImmutableMap<String, RecipeCategory> recipeCategoriesMap;
    private final ListMultimap<RecipeCategory, Object> recipesForCategories;
    private final RecipeMap recipeInputMap;
    private final RecipeMap recipeOutputMap;
    private final Set<Class> unhandledRecipeClasses;
    private final ArrayList<SyncableRecipe> syncableRecipes;
    private final ArrayList<Object> unsyncableRecipes;

    public RecipeRegistry(@Nonnull List<RecipeCategory> recipeCategories, @Nonnull List<RecipeHandler> recipeHandlers, @Nonnull List<RecipeTransferHandler> recipeTransferHandlers, @Nonnull List<Object> recipes, @Nonnull Map<Class<? extends class_293>, RecipeClickableArea> recipeClickableAreas) {
        this.recipeCategoriesMap = RecipeRegistry.buildRecipeCategoriesMap(recipeCategories);
        this.recipeTransferHandlers = RecipeRegistry.buildRecipeTransferHandlerTable(recipeTransferHandlers);
        this.recipeHandlers = RecipeRegistry.buildRecipeHandlersMap(recipeHandlers);
        this.recipeClickableAreas = ImmutableMap.copyOf(recipeClickableAreas);
        RecipeCategoryComparator recipeCategoryComparator = new RecipeCategoryComparator(recipeCategories);
        this.recipeInputMap = new RecipeMap(recipeCategoryComparator);
        this.recipeOutputMap = new RecipeMap(recipeCategoryComparator);
        this.unhandledRecipeClasses = new HashSet<Class>();
        this.recipesForCategories = ArrayListMultimap.create();
        this.syncableRecipes = new ArrayList();
        this.unsyncableRecipes = new ArrayList();
        this.addRecipes(recipes);
    }

    private static ImmutableMap<String, RecipeCategory> buildRecipeCategoriesMap(@Nonnull List<RecipeCategory> recipeCategories) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (RecipeCategory recipeCategory : recipeCategories) {
            mapBuilder.put((Object)recipeCategory.getUid(), (Object)recipeCategory);
        }
        return mapBuilder.build();
    }

    private static ImmutableMap<Class, RecipeHandler> buildRecipeHandlersMap(@Nonnull List<RecipeHandler> recipeHandlers) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        HashSet recipeHandlerClasses = new HashSet();
        for (RecipeHandler recipeHandler : recipeHandlers) {
            if (recipeHandler == null) continue;
            Class recipeClass = recipeHandler.getRecipeClass();
            if (recipeHandlerClasses.contains(recipeClass)) {
                throw new IllegalArgumentException("A Recipe Handler has already been registered for this recipe class: " + recipeClass.getName());
            }
            recipeHandlerClasses.add(recipeClass);
            mapBuilder.put(recipeClass, (Object)recipeHandler);
        }
        return mapBuilder.build();
    }

    private static ImmutableTable<Class, String, RecipeTransferHandler> buildRecipeTransferHandlerTable(@Nonnull List<RecipeTransferHandler> recipeTransferHandlers) {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        for (RecipeTransferHandler recipeTransferHelper : recipeTransferHandlers) {
            builder.put(recipeTransferHelper.getContainerClass(), (Object)recipeTransferHelper.getRecipeCategoryUid(), (Object)recipeTransferHelper);
        }
        return builder.build();
    }

    private void addRecipes(@Nullable List<Object> recipes) {
        if (recipes == null) {
            return;
        }
        for (Object recipe : recipes) {
            this.addRecipe(recipe);
        }
    }

    @Override
    public void addRecipe(@Nullable Object recipe) {
        if (recipe == null) {
            AlwaysMoreItems.LOGGER.error("Null recipe", (Throwable)new NullPointerException());
            return;
        }
        Class<?> recipeClass = recipe.getClass();
        RecipeHandler recipeHandler = this.getRecipeHandler((Class)recipeClass);
        if (recipeHandler == null) {
            if (!this.unhandledRecipeClasses.contains(recipeClass)) {
                this.unhandledRecipeClasses.add(recipeClass);
                if (AMIConfig.isDebugModeEnabled()) {
                    AlwaysMoreItems.LOGGER.debug("Can't handle recipe: {}", recipeClass);
                }
            }
            return;
        }
        String recipeCategoryUid = recipeHandler.getRecipeCategoryUid();
        RecipeCategory recipeCategory = (RecipeCategory)this.recipeCategoriesMap.get((Object)recipeCategoryUid);
        if (recipeCategory == null) {
            AlwaysMoreItems.LOGGER.error("No recipe category registered for recipeCategoryUid: {}", (Object)recipeCategoryUid);
            return;
        }
        if (!recipeHandler.isRecipeValid(recipe)) {
            return;
        }
        try {
            this.addRecipeUnchecked(recipe, recipeCategory, recipeHandler);
        }
        catch (RuntimeException e) {
            String recipeInfo = this.getInfoFromBrokenRecipe(recipe, recipeHandler);
            if (e instanceof ItemUidException) {
                AlwaysMoreItems.LOGGER.error("Found broken recipe: {}\n{}\n", (Object)e.getMessage(), (Object)recipeInfo);
            }
            AlwaysMoreItems.LOGGER.error("Found broken recipe: {}\n", (Object)recipeInfo, (Object)e);
        }
    }

    @Nonnull
    private String getInfoFromBrokenRecipe(@Nonnull Object recipe, @Nonnull RecipeHandler recipeHandler) {
        RecipeWrapper recipeWrapper;
        StringBuilder recipeInfoBuilder = new StringBuilder();
        try {
            recipeInfoBuilder.append(recipe);
        }
        catch (RuntimeException e) {
            AlwaysMoreItems.LOGGER.error("Failed recipe.toString", (Throwable)e);
            recipeInfoBuilder.append(recipe.getClass());
        }
        try {
            recipeWrapper = recipeHandler.getRecipeWrapper(recipe);
        }
        catch (RuntimeException ignored) {
            recipeInfoBuilder.append("\nFailed to create recipe wrapper");
            return recipeInfoBuilder.toString();
        }
        recipeInfoBuilder.append("\nOutput ItemStacks: ");
        try {
            recipeInfoBuilder.append(recipeWrapper.getOutputs());
        }
        catch (RuntimeException e) {
            recipeInfoBuilder.append(e.getMessage());
        }
        recipeInfoBuilder.append("\nInput ItemStacks: ");
        try {
            recipeInfoBuilder.append(recipeWrapper.getInputs());
        }
        catch (RuntimeException e) {
            recipeInfoBuilder.append(e.getMessage());
        }
        return recipeInfoBuilder.toString();
    }

    private void addRecipeUnchecked(@Nonnull Object recipe, RecipeCategory recipeCategory, RecipeHandler recipeHandler) {
        List<?> outputs;
        RecipeWrapper recipeWrapper = recipeHandler.getRecipeWrapper(recipe);
        List<?> inputs = recipeWrapper.getInputs();
        if (inputs != null) {
            List<class_31> inputStacks = AlwaysMoreItems.getStackHelper().toItemStackList(inputs);
            this.recipeInputMap.addRecipe(recipe, recipeCategory, inputStacks);
        }
        if ((outputs = recipeWrapper.getOutputs()) != null) {
            List<class_31> outputStacks = AlwaysMoreItems.getStackHelper().toItemStackList(outputs);
            this.recipeOutputMap.addRecipe(recipe, recipeCategory, outputStacks);
        }
        if (recipe instanceof SyncableRecipe) {
            SyncableRecipe syncableRecipe = (SyncableRecipe)recipe;
            this.syncableRecipes.add(syncableRecipe);
        } else {
            this.unsyncableRecipes.add(recipe);
        }
        this.recipesForCategories.put((Object)recipeCategory, recipe);
    }

    @Nonnull
    public ImmutableList<RecipeCategory> getRecipeCategories() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (RecipeCategory recipeCategory : this.recipeCategoriesMap.values()) {
            if (this.getRecipes(recipeCategory).isEmpty()) continue;
            builder.add((Object)recipeCategory);
        }
        return builder.build();
    }

    @Nonnull
    public ImmutableList<RecipeCategory> getRecipeCategories(@Nullable List<String> recipeCategoryUids) {
        if (recipeCategoryUids == null) {
            AlwaysMoreItems.LOGGER.error("Null recipeCategoryUids", (Throwable)new NullPointerException());
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String recipeCategoryUid : recipeCategoryUids) {
            RecipeCategory recipeCategory = (RecipeCategory)this.recipeCategoriesMap.get((Object)recipeCategoryUid);
            if (recipeCategory == null || this.getRecipes(recipeCategory).isEmpty()) continue;
            builder.add((Object)recipeCategory);
        }
        return builder.build();
    }

    @Nullable
    public RecipeHandler getRecipeHandler(@Nullable Class recipeClass) {
        RecipeHandler recipeHandler;
        if (recipeClass == null) {
            AlwaysMoreItems.LOGGER.error("Null recipeClass", (Throwable)new NullPointerException());
            return null;
        }
        while ((recipeHandler = (RecipeHandler)this.recipeHandlers.get((Object)recipeClass)) == null && recipeClass != Object.class) {
            recipeClass = recipeClass.getSuperclass();
        }
        return recipeHandler;
    }

    @Nullable
    public RecipeClickableArea getRecipeClickableArea(@Nonnull class_293 gui) {
        return (RecipeClickableArea)this.recipeClickableAreas.get(gui.getClass());
    }

    @Nonnull
    public ImmutableList<RecipeCategory> getRecipeCategoriesWithInput(@Nullable class_31 input) {
        if (input == null) {
            AlwaysMoreItems.LOGGER.error("Null ItemStack input", (Throwable)new NullPointerException());
            return ImmutableList.of();
        }
        return this.recipeInputMap.getRecipeCategories(input);
    }

    @Nonnull
    public ImmutableList<RecipeCategory> getRecipeCategoriesWithOutput(@Nullable class_31 output) {
        if (output == null) {
            AlwaysMoreItems.LOGGER.error("Null ItemStack output", (Throwable)new NullPointerException());
            return ImmutableList.of();
        }
        return this.recipeOutputMap.getRecipeCategories(output);
    }

    @Nonnull
    public ImmutableList<Object> getRecipesWithInput(@Nullable RecipeCategory recipeCategory, @Nullable class_31 input) {
        if (recipeCategory == null) {
            AlwaysMoreItems.LOGGER.error("Null recipeCategory", (Throwable)new NullPointerException());
            return ImmutableList.of();
        }
        if (input == null) {
            AlwaysMoreItems.LOGGER.error("Null ItemStack input", (Throwable)new NullPointerException());
            return ImmutableList.of();
        }
        return this.recipeInputMap.getRecipes(recipeCategory, input);
    }

    @Nonnull
    public ImmutableList<Object> getRecipesWithOutput(@Nullable RecipeCategory recipeCategory, @Nullable class_31 output) {
        if (recipeCategory == null) {
            AlwaysMoreItems.LOGGER.error("Null recipeCategory", (Throwable)new NullPointerException());
            return ImmutableList.of();
        }
        if (output == null) {
            AlwaysMoreItems.LOGGER.error("Null ItemStack output", (Throwable)new NullPointerException());
            return ImmutableList.of();
        }
        return this.recipeOutputMap.getRecipes(recipeCategory, output);
    }

    @Override
    @Nonnull
    public List<Object> getRecipes(@Nullable RecipeCategory recipeCategory) {
        if (recipeCategory == null) {
            AlwaysMoreItems.LOGGER.error("Null recipeCategory", (Throwable)new NullPointerException());
            return ImmutableList.of();
        }
        return Collections.unmodifiableList(this.recipesForCategories.get((Object)recipeCategory));
    }

    @Nullable
    public RecipeTransferHandler getRecipeTransferHandler(@Nullable class_71 container, @Nullable RecipeCategory recipeCategory) {
        if (container == null) {
            AlwaysMoreItems.LOGGER.error("Null container", (Throwable)new NullPointerException());
            return null;
        }
        if (recipeCategory == null) {
            AlwaysMoreItems.LOGGER.error("Null recipeCategory", (Throwable)new NullPointerException());
            return null;
        }
        return (RecipeTransferHandler)this.recipeTransferHandlers.get(container.getClass(), (Object)recipeCategory.getUid());
    }

    public ArrayList<SyncableRecipe> getSyncableRecipes() {
        return this.syncableRecipes;
    }

    public ArrayList<Object> getUnsyncableRecipes() {
        return this.unsyncableRecipes;
    }
}

