package net.glasslauncher.mods.alwaysmoreitems.gui.screen;

import com.google.common.collect.ImmutableList;
import net.glasslauncher.mods.alwaysmoreitems.action.ActionButtonRegistry;
import net.glasslauncher.mods.alwaysmoreitems.api.action.ActionButton;
import net.glasslauncher.mods.alwaysmoreitems.config.AMIConfig;
import net.glasslauncher.mods.alwaysmoreitems.gui.RenderHelper;
import net.glasslauncher.mods.alwaysmoreitems.gui.Tooltip;
import net.glasslauncher.mods.alwaysmoreitems.gui.widget.AMISettingsButton;
import net.glasslauncher.mods.alwaysmoreitems.gui.widget.ActionButtonWidget;
import net.glasslauncher.mods.alwaysmoreitems.gui.widget.SearchTextFieldWidget;
import net.glasslauncher.mods.alwaysmoreitems.init.KeybindListener;
import net.glasslauncher.mods.alwaysmoreitems.network.c2s.ActionButtonPacket;
import net.glasslauncher.mods.alwaysmoreitems.network.c2s.GiveItemPacket;
import net.glasslauncher.mods.alwaysmoreitems.recipe.Focus;
import net.glasslauncher.mods.alwaysmoreitems.recipe.ItemFilter;
import net.glasslauncher.mods.alwaysmoreitems.util.AlwaysMoreItems;
import net.glasslauncher.mods.alwaysmoreitems.util.Commands;
import net.glasslauncher.mods.alwaysmoreitems.util.ItemStackElement;
import net.glasslauncher.mods.gcapi3.api.GCAPI;
import net.glasslauncher.mods.gcapi3.impl.GlassYamlFile;
import net.minecraft.class_133;
import net.minecraft.class_264;
import net.minecraft.class_293;
import net.minecraft.class_300;
import net.minecraft.class_31;
import net.minecraft.class_32;
import net.minecraft.class_33;
import net.minecraft.class_564;
import net.minecraft.class_8;
import net.minecraft.client.Minecraft;
import net.modificationstation.stationapi.api.client.TooltipHelper;
import net.modificationstation.stationapi.api.network.packet.PacketHelper;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.math.ColorHelper;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

import javax.management.AttributeNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OverlayScreen extends class_32 {
    public static final OverlayScreen INSTANCE = new OverlayScreen();

    // Parent Screen
    public class_32 parent;

    public final RecipesGui recipesGui = new RecipesGui();

    // Search Field
    public SearchTextFieldWidget searchField;
    public static int searchFieldWidth = 160;

    // Trash Button
    public ActionButtonWidget trashButton;

    // Action Buttons
    ArrayList<ActionButtonWidget> actionButtons;
    public static int maxActionButtonPanelWidth = 100;
    public static int actionButtonOffset = 2;

    // Tooltip
    public List<String> currentTooltip;

    // Item Overlay
    public static int maxItemListWidth = 200;
    public static int maxItemListHeight = 400;
    public static int itemSize = 18;
    ArrayList<ItemRenderEntry> renderedItems;
    public class_33 nextButton;
    public class_33 previousButton;
    public class_33 settingsButton;
    int currentPage = 0;
    int pageCount = 1;
    boolean rolloverPage = true;
    public boolean flipScrollDirection = false;
    public ItemRenderEntry hoveredItem = null;

    // Screen Rescaling Stuff
    private int lastWidth = 0;
    private int lastHeight = 0;
    private int lastItemWidth = 0;
    private int lastItemHeight = 0;
    private int lastScaledWidth = 0;
    private boolean lastCenteredBar = true;

    // Mouse Pos
    int lastMouseX = 0;
    int lastMouseY = 0;

    class_564 screenScaler;

    private OverlayScreen() {
    }

    public void init(class_32 parent, int width, int height) {
        this.parent = parent;
        method_125(Minecraft.field_2791, width, height);
    }

    /**
     * Use init(Screen, int, int) instead.
     *
     * @see #init(class_32, int, int)
     */
    @ApiStatus.Internal
    @Override
    public void method_125(Minecraft minecraft, int width, int height) {
        super.method_125(minecraft, width, height);
    }

    @SuppressWarnings({"unchecked", "OptionalGetWithoutIsPresent"})
    @ApiStatus.Internal
    @Override
    public void method_119() {
        int id = 100;

        field_154.clear();

        // Tooltip
        currentTooltip = null;

        // Search Field
        searchField = new SearchTextFieldWidget(field_156, 0, 0, 0, 20);
        searchField.setMaxLength(64);
        searchField.setText(AlwaysMoreItems.getItemFilter().getFilterText());

        // Settings Button
        settingsButton = new AMISettingsButton(12, 0, 0);
        settingsButton.field_1375 = AlwaysMoreItems.overlayEnabled;
        field_154.add(settingsButton);

        // Adjust search field and settings button
        if (isSearchBarCentered()) {
            searchField.x = (field_152 / 2) - (searchFieldWidth / 2) - 10;
            searchField.y = field_153 - 25;
            searchField.width = searchFieldWidth - 2;

            settingsButton.field_1370 = (field_152 / 2) - (searchFieldWidth / 2) + searchFieldWidth - 11;
            settingsButton.field_1371 = field_153 - 26;
        } else {
            searchField.x = field_152 - (getItemListWidth() * 18);
            searchField.y = field_153 - 21;
            searchField.width = field_152 - 23 - searchField.x;

            settingsButton.field_1370 = field_152 - 22;
            settingsButton.field_1371 = field_153 - 22;
        }

        // Item Overlay
        previousButton = new class_33(10, getOverlayStartX() - 1, 0, 20, 20, "<");
        previousButton.field_1375 = AlwaysMoreItems.overlayEnabled;
        field_154.add(previousButton);

        nextButton = new class_33(11, field_152 - 20, 0, 20, 20, ">");
        nextButton.field_1375 = AlwaysMoreItems.overlayEnabled;
        field_154.add(nextButton);

        // Action Buttons
        actionButtons = new ArrayList<>();
        int actionButtonX = 0;
        int actionButtonY = 0;
        int maxHeightForLine = 0;

        for (int i = 0; i < ActionButtonRegistry.INSTANCE.size(); i++) {
            Identifier identifier = ActionButtonRegistry.INSTANCE.getId(i).get();
            ActionButton value = ActionButtonRegistry.INSTANCE.get(identifier);
            if (value == null) {
                AlwaysMoreItems.LOGGER.error("Identifier {} somehow returned null", identifier, new Throwable());
                continue;
            }
            if (value.dontAddToScreen()) {
                continue;
            }

            if (actionButtonX + value.getWidth() > maxActionButtonPanelWidth) {
                actionButtonX = 0;
                actionButtonY += maxHeightForLine + actionButtonOffset;
                maxHeightForLine = 0;
            }

            if (value.getHeight() > maxHeightForLine) {
                maxHeightForLine = value.getHeight();
            }

            ActionButtonWidget widget = new ActionButtonWidget(id++, actionButtonX, actionButtonY, value.getWidth(), value.getHeight(), value.getTexture());
            actionButtons.add(widget);
            widget.action = value;
            widget.actionIdentifier = identifier;

            actionButtonX += value.getWidth() + actionButtonOffset;
        }

        // Trash Button
        trashButton = new ActionButtonWidget(id + 1, 0, field_153 - 20, 90, 20, "button." + AlwaysMoreItems.NAMESPACE + ".trash", "button." + AlwaysMoreItems.NAMESPACE + ".trash.alt");
        trashButton.actionIdentifier = AlwaysMoreItems.NAMESPACE.id("trash");
        trashButton.action = ActionButtonRegistry.INSTANCE.get(trashButton.actionIdentifier);
        actionButtons.add(trashButton);

        recipesGui.method_119();
    }

    @Override
    public void method_122() {
        // Do not tick if not enabled
        if (AlwaysMoreItems.overlayEnabled) {
            rescale();
        }
        recipesGui.method_122();
    }

    @Override
    public void method_118(int mouseX, int mouseY, float delta) {
        lastMouseX = mouseX;
        lastMouseY = mouseY;

        if (recipesGui.isActive()) {
            recipesGui.drawBackground();
        }
        super.method_118(mouseX, mouseY, delta);

        recipesGui.method_118(mouseX, mouseY, delta);
        amiRender(mouseX, mouseY);
        recipesGui.drawHovered(mouseX, mouseY);
    }

    public void amiRender(int mouseX, int mouseY) {
        // Do not render if not enabled
        if (!AlwaysMoreItems.overlayEnabled) {
            return;
        }

        // Reset Tooltip
        currentTooltip = null;

        // Draw Items
        if (renderedItems != null) {
            RenderHelper.enableItemLighting();
            for (ItemRenderEntry item : renderedItems) {
                if (AMIConfig.isEditModeEnabled()) {
                    if (AMIConfig.isItemOnConfigBlacklist(item.item, false)) { // This exact item is user blacklisted.
                        RenderHelper.disableItemLighting();
                        method_1932(item.x - 1, item.y - 1, item.x + 17, item.y + 17, ColorHelper.Argb.getArgb(255, 255, 0, 0));
                        RenderHelper.enableItemLighting();
                    } else if (AMIConfig.isItemOnConfigBlacklist(item.item, true)) { // This item's ID is user blacklisted.
                        RenderHelper.disableItemLighting();
                        method_1932(item.x - 1, item.y - 1, item.x + 17, item.y + 17, ColorHelper.Argb.getArgb(255, 255, 255, 0));
                        RenderHelper.enableItemLighting();
                    }
                }
                RenderHelper.drawItemStack(item.x, item.y, item.item, false);
            }
            RenderHelper.disableItemLighting();
        }

        // Draw Slot Highlight
        hoveredItem = getHoveredItem(mouseX, mouseY);
        if (hoveredItem != null) {
            this.method_1932(hoveredItem.x - 1, hoveredItem.y - 1, hoveredItem.x + itemSize - 1, hoveredItem.y + itemSize - 1, -2130706433);
            String simpleTip = class_300.method_992().method_993(hoveredItem.item.method_726() + ".name");
            currentTooltip = TooltipHelper.getTooltipForItemStack(simpleTip, hoveredItem.item, Minecraft.field_2791.field_2806.field_519, null);
        }

        // Draw Page Number
        String pageNumberString = (pageCount == 0 ? 0 : (currentPage + 1)) + "/" + pageCount;
        field_156.method_1903(
                pageNumberString,
                (field_152 - ((field_152 - getOverlayStartX()) / 2)) - (field_156.method_1901(pageNumberString) / 2),
                6,
                -1
        );

        // Draw Search Field and Settings Button
        searchField.draw(mouseX, mouseY);

        // Draw Action Buttons
        for (var actionButton : actionButtons) {
            actionButton.method_1186(field_151, mouseX, mouseY);

            if (!actionButton.action.tooltipEnabled()) {
                continue;
            }

            if (currentTooltip == null && actionButton.method_1189(field_151, mouseX, mouseY)) {
                boolean holdingShift = Keyboard.isKeyDown(Keyboard.KEY_LSHIFT) || Keyboard.isKeyDown(Keyboard.KEY_RSHIFT);
                String translationKey = AlwaysMoreItems.NAMESPACE + ".actionButton." + actionButton.actionIdentifier.namespace + "." + actionButton.actionIdentifier.path;

                if (holdingShift && !class_300.method_992().method_993(translationKey + ".alt").equals(translationKey + ".alt")) {
                    currentTooltip = Collections.singletonList(class_300.method_992().method_993(translationKey + ".alt"));
                } else {
                    currentTooltip = Collections.singletonList(class_300.method_992().method_993(translationKey));
                }
            }
        }

        if (Minecraft.field_2791.field_2806.field_519.method_689() != null && mouseX >= getOverlayStartX() && mouseY > 21) {
            currentTooltip = new ArrayList<>() {{
                add(class_300.method_992().method_994("button.alwaysmoreitems.trash.cursor", class_300.method_992().method_993(Minecraft.field_2791.field_2806.field_519.method_689().method_726() + ".name")));
            }};
        }

        // Queue Tooltip
        if (currentTooltip != null && !currentTooltip.isEmpty()) {
            Tooltip.INSTANCE.setTooltip(new ArrayList<>(currentTooltip), mouseX, mouseY);
        }
    }

    @Override
    public void method_124(int mouseX, int mouseY, int button) {
        // Pass thru clicks to recipes gui
        recipesGui.method_124(mouseX, mouseY, button);

        // Do not process if not enabled
        if (!AlwaysMoreItems.overlayEnabled) {
            return;
        }

        super.method_124(mouseX, mouseY, button);

        if (Minecraft.field_2791.field_2806.field_519.method_689() != null && mouseX >= getOverlayStartX() && mouseY > 21) {
            if (!field_151.field_2804.field_180) {
                trashButton.performAction(field_151, field_151.field_2804, field_151.field_2806, true, button, false);
            } else {
                PacketHelper.send(new ActionButtonPacket(trashButton.actionIdentifier, button, false));
            }
            return;
        }

        // Search Field
        searchField.mouseClicked(mouseX, mouseY, button);
        if (ItemFilter.setFilterText(searchField.getText())) {
            rebuildRenderList();
        }

        // Action Buttons
        for (var actionButton : actionButtons) {
            if (actionButton.method_1189(field_151, mouseX, mouseY)) {
                this.field_151.field_2766.method_2009(actionButton.action.getClickSound(), 1.0F, 1.0F);
                boolean holdingShift = Keyboard.isKeyDown(Keyboard.KEY_LSHIFT) || Keyboard.isKeyDown(Keyboard.KEY_RSHIFT);
                if (!field_151.field_2804.field_180 || actionButton.action.isClientsideOnly()) {
                    actionButton.performAction(field_151, field_151.field_2804, field_151.field_2806, true, button, holdingShift);
                } else {
                    PacketHelper.send(new ActionButtonPacket(actionButton.actionIdentifier, button, holdingShift));
                }
            }
        }

        // Hovered Item
        if (hoveredItem != null) {
            if (AMIConfig.isEditModeEnabled() && button == 0) {
                boolean isCtrl = Keyboard.isKeyDown(Keyboard.KEY_LCONTROL);
                if (!AMIConfig.isItemOnConfigBlacklist(hoveredItem.item, isCtrl)) {
                    AMIConfig.addItemToConfigBlacklist(hoveredItem.item, isCtrl);
                } else {
                    AMIConfig.removeItemFromConfigBlacklist(hoveredItem.item, isCtrl);
                }
                return;
            }

            if (!AMIConfig.INSTANCE.cheatMode || recipesGui.isActive()) {
                if (button == 0) { // LMB - Show Recipe
                    showRecipe(new Focus(hoveredItem.item));
                } else if (button == 1) { // RMB - Show Uses
                    showUses(new Focus(hoveredItem.item));
                }
                return;
            }

            if (AlwaysMoreItems.isAMIOnServer()) {
                class_8 itemNbt = new class_8();
                hoveredItem.item.method_706(itemNbt);

                if (button == 0) { // LMB - Give Stack
                    itemNbt.method_1012("Count", (byte) hoveredItem.item.method_709());
                } else if (button == 1) { // RMB - Give One
                    itemNbt.method_1012("Count", (byte) Math.min(AMIConfig.getRightClickGiveAmount(), hoveredItem.item.method_709()));
                } else {
                    return; // Some other mouse button was pressed
                }

                PacketHelper.send(new GiveItemPacket(itemNbt));
            } else {
                if (button == 0) { // LMB - Give Stack
                    Commands.giveStack(hoveredItem.item, hoveredItem.item.method_709());
                } else if (button == 1) { // RMB - Give One
                    Commands.giveStack(hoveredItem.item, Math.min(AMIConfig.getRightClickGiveAmount(), hoveredItem.item.method_709()));
                }
            }
        }
    }

    @Override
    public void method_131() {
        // Do not process if not enabled
        if (!AlwaysMoreItems.overlayEnabled) {
            return;
        }

        super.method_131();

        int mouseX = Mouse.getEventX() * this.field_152 / this.field_151.field_2802;
        int dWheel = Mouse.getEventDWheel();
        if (mouseX >= getOverlayStartX() && dWheel != 0) {
            if (flipScrollDirection) {
                flipPage(dWheel);
            } else {
                flipPage(-dWheel);
            }
        }
    }

    @Override
    public void method_117(char character, int keyCode) {
        if (OverlayScreen.INSTANCE.overlayKeyPressed(character, keyCode)) {
            return;
        }
        super.method_117(character, keyCode);
    }

    public boolean overlayKeyPressed(char character, int keyCode) {
        // Toggle Overlay
        if (keyCode == KeybindListener.toggleOverlay.field_2381 && !searchField.isSelected()) {
            AlwaysMoreItems.overlayEnabled = !AlwaysMoreItems.overlayEnabled;

            screenScaler = new class_564(field_151.field_2824, field_151.field_2802, field_151.field_2803);
            field_151.field_2816.method_125(field_151, screenScaler.method_1857(), screenScaler.method_1858());

            previousButton.field_1375 = previousButton.field_1374 = AlwaysMoreItems.overlayEnabled;
            nextButton.field_1375 = nextButton.field_1374 = AlwaysMoreItems.overlayEnabled;
            settingsButton.field_1375 = settingsButton.field_1374 = AlwaysMoreItems.overlayEnabled;
        }

        if (recipesGui.recipeKeyPressed(keyCode)) {
            return true;
        }

        // Cancel keys if overlay is not enabled
        if (!AlwaysMoreItems.overlayEnabled) {
            return false;
        }

        // Search Field
        if (searchField.isSelected()) {
            searchField.keyPressed(character, keyCode);
            ItemFilter.setFilterText(searchField.getText());
            currentPage = 0; //Math.min(pageCount - 1, currentPage);
            rebuildRenderList();
            return true;
        }

        // Item Actions
        // Check items from item menu
        if (hoveredItem != null) {
            // Show Recipes
            if (keyCode == KeybindListener.showRecipe.field_2381) {
                showRecipe(new Focus(hoveredItem.item));
                return true;
            }

            // Show Uses
            if (keyCode == KeybindListener.showUses.field_2381) {
                showUses(new Focus(hoveredItem.item));
                return true;
            }
        }

        // Check Inventory Items
        if (parent instanceof class_293 handled) {
            class_133 hoveredSlot = handled.method_986(lastMouseX, lastMouseY);

            if (hoveredSlot != null && hoveredSlot.method_476()) {
                // Show Recipes
                if (keyCode == KeybindListener.showRecipe.field_2381) {
                    recipesGui.showRecipes(new Focus(hoveredSlot.method_472()));
                    return true;
                }

                // Show Uses
                else if (keyCode == KeybindListener.showUses.field_2381) {
                    recipesGui.showUses(new Focus(hoveredSlot.method_472()));
                    return true;
                }
            }
        }

        // Go Back
        if (keyCode == KeybindListener.recipeBack.field_2381) {
            recipesGui.back();
            return true;
        }

        return false;
    }

    public void showRecipe(Focus item) {
        recipesGui.showRecipes(item);
    }

    public void showUses(Focus item) {
        recipesGui.showUses(item);
    }

    @Override
    protected void method_120(class_33 button) {
        recipesGui.method_120(button);

        if (button.field_1373 == previousButton.field_1373) {
            flipPage(-1);
        }

        if (button.field_1373 == nextButton.field_1373) {
            flipPage(1);
        }

        if (button.field_1373 == settingsButton.field_1373) {
            if (Keyboard.isKeyDown(Keyboard.KEY_LCONTROL)) {
                GCAPI.reloadConfig(AlwaysMoreItems.NAMESPACE.id("config").toString(), new GlassYamlFile() {{
                    set("cheatMode", !AMIConfig.INSTANCE.cheatMode);
                }});
                return;
            }
            try {
                Minecraft.field_2791.method_2112(GCAPI.getRootConfigScreen(AlwaysMoreItems.NAMESPACE.id("config").toString(), parent));
            } catch (AttributeNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /**
     * Checks if the display dimensions have changed since the last time the method was ran and if so,
     * recalculates the scaled width and height
     */
    public void rescale() {
        if (field_151 == null) {
            field_151 = Minecraft.field_2791;
        }

        screenScaler = new class_564(field_151.field_2824, field_151.field_2802, field_151.field_2803);

        if (field_151.field_2802 != lastWidth || field_151.field_2803 != lastHeight || AMIConfig.INSTANCE.maxItemListWidth != lastItemWidth || AMIConfig.INSTANCE.maxItemListHeight != lastItemHeight || screenScaler.method_1857() != lastScaledWidth || isSearchBarCentered() != lastCenteredBar) {
            // Get the item list dimensions
            maxItemListWidth = AMIConfig.INSTANCE.maxItemListWidth;
            maxItemListHeight = AMIConfig.INSTANCE.maxItemListHeight;

            // Run screen scaler
            field_152 = screenScaler.method_1857();
            field_153 = screenScaler.method_1858();

            // Store Last values
            lastWidth = field_151.field_2802;
            lastHeight = field_151.field_2803;
            lastItemWidth = maxItemListWidth;
            lastItemHeight = maxItemListHeight;
            lastScaledWidth = field_152;
            lastCenteredBar = isSearchBarCentered();

            // Rebuild the screen
            currentPage = 0;
            field_151.field_2816.method_125(field_151, screenScaler.method_1857(), screenScaler.method_1858());
            rebuildRenderList();
        }
    }

    public int getItemListWidth() {
        int possibleOverlayStartX;
        if (parent instanceof class_293 handledScreen) {
            possibleOverlayStartX = ((parent.field_152 - handledScreen.field_1152) / 2) + handledScreen.field_1152 + 10;
        } else if (parent instanceof RecipesGui recipesGuiParent) {
            possibleOverlayStartX = ((parent.field_152 - recipesGuiParent.getXSize()) / 2) + recipesGuiParent.getXSize() + 10;
        } else {
            throw new RuntimeException("Unsupported Screen fed to OverlayScreen!");
        }
        return Math.min(((field_152 - possibleOverlayStartX) / itemSize), maxItemListWidth);
    }

    public int getItemListHeight() {
        if (isSearchBarCentered()) {
            return Math.min(((field_153 - 20) / itemSize), maxItemListHeight);
        } else {
            return Math.min(((field_153 - 42) / itemSize), maxItemListHeight);
        }
    }

    public boolean isSearchBarCentered() {
        if (screenScaler == null) {
            screenScaler = new class_564(field_151.field_2824, field_151.field_2802, field_151.field_2803);
        }

        return AMIConfig.centeredSearchBar() && !(screenScaler.method_1858() <= 275 && field_151.field_2816 instanceof class_264);
    }

    public int getOverlayStartX() {
        return field_152 - (getItemListWidth() * itemSize);
    }

    public ItemRenderEntry getHoveredItem(int mouseX, int mouseY) {
        if (renderedItems == null || !AlwaysMoreItems.overlayEnabled) {
            return null;
        }

        if (mouseY <= 21 || mouseX < getOverlayStartX()) {
            return null;
        }

        int itemX = (mouseX - getOverlayStartX()) / itemSize;
        int itemY = (mouseY - 21) / itemSize;
        int itemIndexOnPage = (itemY * getItemListWidth()) + itemX;

        if (itemIndexOnPage < renderedItems.size() && itemIndexOnPage >= 0) {
            return renderedItems.get(itemIndexOnPage);
        } else {
            return null;
        }
    }

    // Rebuild the list of items that are rendered
    public void rebuildRenderList() {
        // Filtered
        ImmutableList<ItemStackElement> filteredItems = AlwaysMoreItems.getItemFilter().getItemList();

        // Rendered
        renderedItems = new ArrayList<>();

        int itemListWidth = getItemListWidth();
        int itemListHeight = getItemListHeight();
        int overlayStartX = getOverlayStartX();
        int itemsPerPage = itemListWidth * itemListHeight;
        pageCount = (int) Math.ceil((double) filteredItems.size() / itemsPerPage);

        for (int yIndex = 0; yIndex < itemListHeight; yIndex++) {
            for (int xIndex = 0; xIndex < itemListWidth; xIndex++) {
                int itemIndexOnThisPage = (yIndex * itemListWidth) + xIndex;
                int itemIndex = (currentPage * itemsPerPage) + itemIndexOnThisPage;

                if (itemIndex >= filteredItems.size()) {
                    return;
                }

                renderedItems.add(
                        new ItemRenderEntry(
                                overlayStartX + (xIndex * itemSize),
                                21 + (yIndex * itemSize),
                                filteredItems.get(itemIndex).getItemStack()
                        )
                );
            }
        }
    }

    public void flipPage(int direction) {
        if (direction > 0) {
            if (currentPage < pageCount - 1) {
                currentPage++;
            } else {
                if (rolloverPage) {
                    currentPage = 0;
                }
            }
        } else if (direction < 0) {
            if (currentPage > 0) {
                currentPage--;
            } else {
                if (rolloverPage) {
                    currentPage = Math.max(pageCount - 1, 0);
                }
            }
        }
        rebuildRenderList();
    }

    public record ItemRenderEntry(int x, int y, class_31 item) {
    }
}
