/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.gui.widget.ingredients;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.glasslauncher.mods.alwaysmoreitems.api.gui.TooltipCallback;
import net.glasslauncher.mods.alwaysmoreitems.gui.widget.ingredients.GuiIngredient;
import net.glasslauncher.mods.alwaysmoreitems.recipe.Focus;
import net.minecraft.client.Minecraft;

public abstract class GuiIngredientGroup<V, T extends GuiIngredient<V>>
implements net.glasslauncher.mods.alwaysmoreitems.api.gui.GuiIngredientGroup<V> {
    protected final int itemCycleOffset = (int)(Math.random() * 1000.0);
    @Nonnull
    protected final Map<Integer, T> guiIngredients = new HashMap<Integer, T>();
    @Nonnull
    protected Focus focus = new Focus();
    @Nullable
    private TooltipCallback<V> tooltipCallback;

    public void setFocus(@Nonnull Focus focus) {
        this.focus = focus;
    }

    @Override
    public void set(int slotIndex, @Nonnull Collection<V> values) {
        ((GuiIngredient)this.guiIngredients.get(slotIndex)).set(values, this.focus);
    }

    @Override
    public void set(int slotIndex, @Nonnull V value) {
        ((GuiIngredient)this.guiIngredients.get(slotIndex)).set(value, this.focus);
    }

    @Override
    public void addTooltipCallback(@Nonnull TooltipCallback<V> tooltipCallback) {
        this.tooltipCallback = tooltipCallback;
    }

    @Override
    @Nonnull
    public Map<Integer, T> getGuiIngredients() {
        return this.guiIngredients;
    }

    @Nullable
    public Focus getFocusUnderMouse(int mouseX, int mouseY) {
        for (GuiIngredient widget : this.guiIngredients.values()) {
            if (widget == null || !widget.isMouseOver(mouseX, mouseY)) continue;
            return Focus.create(widget.get());
        }
        return null;
    }

    @Nullable
    public T draw(@Nonnull Minecraft minecraft, int mouseX, int mouseY) {
        GuiIngredient hovered = null;
        for (GuiIngredient ingredient : this.guiIngredients.values()) {
            if (hovered == null && ingredient.isMouseOver(mouseX, mouseY)) {
                hovered = ingredient;
                hovered.setTooltipCallback(this.tooltipCallback);
                continue;
            }
            ingredient.draw(minecraft);
        }
        return (T)hovered;
    }
}

