package net.glasslauncher.mods.alwaysmoreitems.mixin.client;

import net.glasslauncher.mods.alwaysmoreitems.gui.screen.OverlayScreen;
import net.minecraft.class_293;
import net.minecraft.class_32;
import net.minecraft.client.Minecraft;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_293.class)
public class OverlayScreenInjectionsMixin extends class_32 {

    @Override
    public void method_125(Minecraft minecraft, int width, int height) {
        super.method_125(minecraft, width, height);
        OverlayScreen.INSTANCE.init(this, width, height);
    }

    @Inject(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/ingame/HandledScreen;drawBackground(F)V", shift = At.Shift.AFTER))
    public void render(int mouseX, int mouseY, float delta, CallbackInfo ci) {
        OverlayScreen.INSTANCE.method_118(mouseX, mouseY, delta);
    }

    @Inject(method = "tick", at = @At(value = "TAIL"))
    public void tick(CallbackInfo ci) {
        OverlayScreen.INSTANCE.method_122();
    }

    @Inject(method = "keyPressed", at = @At(value = "HEAD"), cancellable = true)
    public void keyPressed(char character, int keyCode, CallbackInfo ci) {
        if (OverlayScreen.INSTANCE.overlayKeyPressed(character, keyCode)) {
            ci.cancel();
        }
    }

    @Override
    public void method_131() {
        OverlayScreen.INSTANCE.method_131();
        super.method_131();
    }
}
