/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.util;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.glasslauncher.mods.alwaysmoreitems.api.recipe.RecipeCategory;
import net.glasslauncher.mods.alwaysmoreitems.api.recipe.RecipeHandler;
import net.glasslauncher.mods.alwaysmoreitems.api.recipe.RecipeWrapper;
import net.glasslauncher.mods.alwaysmoreitems.gui.RecipeLayout;
import net.glasslauncher.mods.alwaysmoreitems.recipe.Focus;
import net.glasslauncher.mods.alwaysmoreitems.registry.RecipeRegistry;
import net.glasslauncher.mods.alwaysmoreitems.util.AlwaysMoreItems;
import net.glasslauncher.mods.alwaysmoreitems.util.MathUtil;
import net.minecraft.class_71;
import net.minecraft.client.Minecraft;

public class RecipeGuiLogic {
    @Nullable
    private State state = null;
    @Nonnull
    private final Stack<State> history = new Stack();
    @Nonnull
    private List<RecipeCategory> recipeCategories = ImmutableList.of();
    @Nonnull
    private List<Object> recipes = Collections.emptyList();
    private int recipesPerPage = 0;

    public boolean setFocus(@Nonnull Focus focus) {
        return this.setFocus(focus, true);
    }

    public boolean back() {
        if (this.history.empty()) {
            return false;
        }
        State state = this.history.pop();
        if (this.setFocus(state.focus, false)) {
            this.state = state;
            return true;
        }
        return false;
    }

    private boolean setFocus(@Nonnull Focus focus, boolean saveHistory) {
        if (this.state != null && this.state.focus.equalsFocus(focus)) {
            return true;
        }
        List<RecipeCategory> types = focus.getCategories();
        if (types.isEmpty()) {
            return false;
        }
        this.recipeCategories = types;
        int recipeCategoryIndex = 0;
        class_71 container = Minecraft.field_2791.field_2806.field_521;
        if (container != null) {
            for (int i = 0; i < this.recipeCategories.size(); ++i) {
                RecipeCategory recipeCategory = this.recipeCategories.get(i);
                if (AlwaysMoreItems.getRecipeRegistry().getRecipeTransferHandler(container, recipeCategory) == null) continue;
                recipeCategoryIndex = i;
                break;
            }
        }
        if (this.state != null && saveHistory) {
            this.history.push(this.state);
        }
        this.state = new State(focus, recipeCategoryIndex, 0);
        this.updateRecipes();
        return true;
    }

    public boolean setCategoryFocus() {
        RecipeCategory recipeCategory = this.getRecipeCategory();
        if (recipeCategory == null) {
            return false;
        }
        if (this.state != null) {
            this.history.push(this.state);
        }
        this.recipeCategories = AlwaysMoreItems.getRecipeRegistry().getRecipeCategories();
        int recipeCategoryIndex = this.recipeCategories.indexOf(recipeCategory);
        this.state = new State(new Focus(), recipeCategoryIndex, 0);
        this.updateRecipes();
        return true;
    }

    public boolean setCategoryFocus(List<String> recipeCategoryUids) {
        ImmutableList<RecipeCategory> recipeCategories = AlwaysMoreItems.getRecipeRegistry().getRecipeCategories(recipeCategoryUids);
        if (recipeCategories.isEmpty()) {
            return false;
        }
        if (this.state != null) {
            this.history.push(this.state);
        }
        this.recipeCategories = recipeCategories;
        this.state = new State(new Focus(), 0, 0);
        this.updateRecipes();
        return true;
    }

    public Focus getFocus() {
        if (this.state == null) {
            return null;
        }
        return this.state.focus;
    }

    public void setRecipesPerPage(int recipesPerPage) {
        if (this.state == null) {
            return;
        }
        if (this.recipesPerPage != recipesPerPage) {
            int recipeIndex = this.state.pageIndex * this.recipesPerPage;
            this.state.pageIndex = recipeIndex / recipesPerPage;
            this.recipesPerPage = recipesPerPage;
            this.updateRecipes();
        }
    }

    private void updateRecipes() {
        if (this.state == null) {
            return;
        }
        RecipeCategory recipeCategory = this.getRecipeCategory();
        this.recipes = this.state.focus.getRecipes(recipeCategory);
    }

    public RecipeCategory getRecipeCategory() {
        if (this.state == null || this.recipeCategories.isEmpty()) {
            return null;
        }
        return this.recipeCategories.get(this.state.recipeCategoryIndex);
    }

    @Nonnull
    public List<RecipeLayout> getRecipeWidgets(int posX, int posY, int spacingY) {
        if (this.state == null) {
            return Collections.emptyList();
        }
        ArrayList<RecipeLayout> recipeWidgets = new ArrayList<RecipeLayout>();
        RecipeCategory recipeCategory = this.getRecipeCategory();
        if (recipeCategory == null) {
            return recipeWidgets;
        }
        RecipeRegistry recipeRegistry = AlwaysMoreItems.getRecipeRegistry();
        int recipeWidgetIndex = 0;
        for (int recipeIndex = this.state.pageIndex * this.recipesPerPage; recipeIndex < this.recipes.size() && recipeWidgets.size() < this.recipesPerPage; ++recipeIndex) {
            Object recipe = this.recipes.get(recipeIndex);
            RecipeHandler<?> recipeHandler = recipeRegistry.getRecipeHandler(recipe.getClass());
            if (recipeHandler == null) {
                AlwaysMoreItems.LOGGER.error("Couldn't find recipe handler for recipe: {}", recipe);
                continue;
            }
            RecipeWrapper recipeWrapper = recipeHandler.getRecipeWrapper(recipe);
            RecipeLayout recipeWidget = new RecipeLayout(recipeWidgetIndex++, posX, posY, recipeCategory, recipeWrapper, this.state.focus);
            recipeWidgets.add(recipeWidget);
            posY += spacingY;
        }
        return recipeWidgets;
    }

    public void nextRecipeCategory() {
        if (this.state == null) {
            return;
        }
        int recipesTypesCount = this.recipeCategories.size();
        this.state.recipeCategoryIndex = (this.state.recipeCategoryIndex + 1) % recipesTypesCount;
        this.state.pageIndex = 0;
        this.updateRecipes();
    }

    public boolean hasMultiplePages() {
        return this.recipes.size() > this.recipesPerPage;
    }

    public void previousRecipeCategory() {
        if (this.state == null) {
            return;
        }
        int recipesTypesCount = this.recipeCategories.size();
        this.state.recipeCategoryIndex = (recipesTypesCount + this.state.recipeCategoryIndex - 1) % recipesTypesCount;
        this.state.pageIndex = 0;
        this.updateRecipes();
    }

    public void nextPage() {
        if (this.state == null) {
            return;
        }
        int pageCount = this.pageCount(this.recipesPerPage);
        this.state.pageIndex = (this.state.pageIndex + 1) % pageCount;
        this.updateRecipes();
    }

    public void previousPage() {
        if (this.state == null) {
            return;
        }
        int pageCount = this.pageCount(this.recipesPerPage);
        this.state.pageIndex = (pageCount + this.state.pageIndex - 1) % pageCount;
        this.updateRecipes();
    }

    private int pageCount(int recipesPerPage) {
        if (this.recipes.size() <= 1) {
            return 1;
        }
        return MathUtil.divideCeil(this.recipes.size(), recipesPerPage);
    }

    @Nonnull
    public String getPageString() {
        if (this.state == null) {
            return "1/1";
        }
        return this.state.pageIndex + 1 + "/" + this.pageCount(this.recipesPerPage);
    }

    public boolean hasMultipleCategories() {
        return this.recipeCategories.size() > 1;
    }

    private static class State {
        @Nonnull
        public final Focus focus;
        public int recipeCategoryIndex;
        public int pageIndex;

        public State(@Nonnull Focus focus, int recipeCategoryIndex, int pageIndex) {
            this.focus = focus;
            this.recipeCategoryIndex = recipeCategoryIndex;
            this.pageIndex = pageIndex;
        }
    }
}

