package net.glasslauncher.mods.alwaysmoreitems.api.recipe.transfer;

import java.util.List;
import net.minecraft.class_133;
import net.minecraft.class_71;

/**
 * Gives AMI the information it needs to transfer recipes from a slotted inventory into the crafting area.
 * <p>
 * Most plugins should create new IRecipeTransferInfo instances with IModRegistry.createRecipeTransferHelper.
 * Containers with slot ranges that contain gaps or other oddities can implement this interface directly.
 * Containers that need full control over the recipe transfer or do not use slots can implement IRecipeTransferHandler.
 */
public interface RecipeTransferInfo {
    /**
     * Return the container class that this recipe transfer helper supports
     */
    Class<? extends class_71> getContainerClass();

    /**
     * Return the recipe category that this container can handle.
     */
    String getRecipeCategoryUid();

    /**
     * Return a list of slots for the recipe area.
     */
    List<class_133> getRecipeSlots(class_71 container);

    /**
     * Return a list of slots that the transfer can use to get items for crafting, or place leftover items.
     */
    List<class_133> getInventorySlots(class_71 container);
}
