package net.glasslauncher.mods.alwaysmoreitems.transfer;

import net.glasslauncher.mods.alwaysmoreitems.api.recipe.transfer.RecipeTransferInfo;
import net.minecraft.class_133;
import net.minecraft.class_71;
import java.util.ArrayList;
import java.util.List;

public class BasicRecipeTransferInfo implements RecipeTransferInfo {
    private final Class<? extends class_71> containerClass;
    private final String recipeCategoryUid;
    private final int recipeSlotStart;
    private final int recipeSlotCount;
    private final int inventorySlotStart;
    private final int inventorySlotCount;

    public BasicRecipeTransferInfo(Class<? extends class_71> containerClass, String recipeCategoryUid, int recipeSlotStart, int recipeSlotCount, int inventorySlotStart, int inventorySlotCount) {
        this.containerClass = containerClass;
        this.recipeCategoryUid = recipeCategoryUid;
        this.recipeSlotStart = recipeSlotStart;
        this.recipeSlotCount = recipeSlotCount;
        this.inventorySlotStart = inventorySlotStart;
        this.inventorySlotCount = inventorySlotCount;
    }

    @Override
    public Class<? extends class_71> getContainerClass() {
        return containerClass;
    }

    @Override
    public String getRecipeCategoryUid() {
        return recipeCategoryUid;
    }

    @Override
    public List<class_133> getRecipeSlots(class_71 container) {
        List<class_133> slots = new ArrayList<>();
        for (int i = recipeSlotStart; i < recipeSlotStart + recipeSlotCount; i++) {
            class_133 slot = container.method_2084(i);
            slots.add(slot);
        }
        return slots;
    }

    @Override
    public List<class_133> getInventorySlots(class_71 container) {
        List<class_133> slots = new ArrayList<>();
        for (int i = inventorySlotStart; i < inventorySlotStart + inventorySlotCount; i++) {
            class_133 slot = container.method_2084(i);
            slots.add(slot);
        }
        return slots;
    }
}
