/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.network.s2c;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.glasslauncher.mods.alwaysmoreitems.api.ModPluginProvider;
import net.glasslauncher.mods.alwaysmoreitems.api.SyncableRecipe;
import net.glasslauncher.mods.alwaysmoreitems.init.CommonInit;
import net.glasslauncher.mods.alwaysmoreitems.network.NetworkHelper;
import net.glasslauncher.mods.alwaysmoreitems.util.AlwaysMoreItems;
import net.glasslauncher.mods.alwaysmoreitems.util.ModRegistry;
import net.minecraft.class_169;
import net.minecraft.class_187;
import net.minecraft.class_202;
import net.minecraft.class_240;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.network.packet.ManagedPacket;
import net.modificationstation.stationapi.api.network.packet.PacketType;
import net.modificationstation.stationapi.api.util.Identifier;
import org.jetbrains.annotations.NotNull;

public class RecipeSyncPacket
extends class_169
implements ManagedPacket<RecipeSyncPacket> {
    public static final PacketType<RecipeSyncPacket> TYPE = PacketType.builder((boolean)true, (boolean)false, RecipeSyncPacket::new).build();
    private static final String PLUGIN_KEY = AlwaysMoreItems.NAMESPACE.id("plugin").toString();
    private static class_202 CACHED_DATA;
    private int outSize;
    private ArrayList<SyncableRecipe> readData;

    public void method_806(DataInputStream stream) {
        class_202 nbtList = new class_202();
        nbtList.method_630((DataInput)stream);
        ArrayList<SyncableRecipe> recipes = new ArrayList<SyncableRecipe>();
        for (int i = 0; i < nbtList.method_1398(); ++i) {
            class_8 nbtCompound = (class_8)nbtList.method_1396(i);
            String pluginKey = nbtCompound.method_1031(PLUGIN_KEY);
            ModPluginProvider plugin = (ModPluginProvider)CommonInit.getPlugins().get((Object)Identifier.of((String)pluginKey));
            if (plugin == null) {
                AlwaysMoreItems.LOGGER.warn("Plugin {} not found, recipes from this plugin won't function. Are you missing a mod?", (Object)pluginKey);
                continue;
            }
            SyncableRecipe syncableRecipe = plugin.deserializeRecipe(nbtCompound);
            if (syncableRecipe == null) continue;
            recipes.add(syncableRecipe);
        }
        this.readData = recipes;
    }

    public void method_807(DataOutputStream stream) {
        if (CACHED_DATA == null) {
            AlwaysMoreItems.LOGGER.info("Loading recipes to server cache.");
            CACHED_DATA = new class_202();
            AlwaysMoreItems.getRecipeRegistry().getSyncableRecipes().forEach(syncableRecipe -> {
                class_8 nbtCompound = syncableRecipe.exportRecipe();
                nbtCompound.method_1019(PLUGIN_KEY, syncableRecipe.getPlugin().toString());
                CACHED_DATA.method_1397((class_187)nbtCompound);
            });
        }
        this.outSize = NetworkHelper.writeAndGetNbtLength((class_187)CACHED_DATA, stream);
    }

    public void method_808(class_240 networkHandler) {
        if (FabricLoader.getInstance().getEnvironmentType().equals((Object)EnvType.SERVER)) {
            return;
        }
        ModRegistry modRegistry = new ModRegistry(CommonInit.getModRegistry());
        modRegistry.addRecipes(this.readData);
        modRegistry.addRecipes(AlwaysMoreItems.getRecipeRegistry().getUnsyncableRecipes());
        AlwaysMoreItems.setRecipeRegistry(modRegistry.createRecipeRegistry());
        AlwaysMoreItems.LOGGER.info("Synced {} recipes from server to client, skipped {} unhandled recipes.", (Object)this.readData.size(), (Object)AlwaysMoreItems.getRecipeRegistry().getUnsyncableRecipes().size());
    }

    public int method_798() {
        return this.outSize;
    }

    @NotNull
    public PacketType<RecipeSyncPacket> getType() {
        return TYPE;
    }
}

