/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.recipe;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.glasslauncher.mods.alwaysmoreitems.config.AMIConfig;
import net.glasslauncher.mods.alwaysmoreitems.util.AlwaysMoreItems;
import net.minecraft.class_31;

public class ItemBlacklist
implements net.glasslauncher.mods.alwaysmoreitems.api.ItemBlacklist {
    @Nonnull
    private final Set<String> itemBlacklist = new HashSet<String>();

    @Override
    public void addItemToBlacklist(@Nullable class_31 itemStack) {
        if (itemStack == null) {
            AlwaysMoreItems.LOGGER.error("Null itemStack", (Throwable)new NullPointerException());
            return;
        }
        String uid = AlwaysMoreItems.getStackHelper().getUniqueIdentifierForStack(itemStack);
        this.itemBlacklist.add(uid);
        AlwaysMoreItems.resetItemFilter();
    }

    @Override
    public void removeItemFromBlacklist(@Nullable class_31 itemStack) {
        if (itemStack == null) {
            AlwaysMoreItems.LOGGER.error("Null itemStack", (Throwable)new NullPointerException());
            return;
        }
        String uid = AlwaysMoreItems.getStackHelper().getUniqueIdentifierForStack(itemStack);
        this.itemBlacklist.remove(uid);
        AlwaysMoreItems.resetItemFilter();
    }

    @Override
    public boolean isItemBlacklisted(@Nullable class_31 itemStack) {
        if (itemStack == null) {
            AlwaysMoreItems.LOGGER.error("Null itemStack", (Throwable)new NullPointerException());
            return false;
        }
        List<String> uids = AlwaysMoreItems.getStackHelper().getUniqueIdentifiersWithWildcard(itemStack);
        return uids.stream().anyMatch(uid -> this.itemBlacklist.contains(uid) || AMIConfig.INSTANCE.itemBlacklist.contains(uid));
    }

    @Override
    public boolean isItemAPIBlacklisted(@Nullable class_31 itemStack) {
        if (itemStack == null) {
            AlwaysMoreItems.LOGGER.error("Null itemStack", (Throwable)new NullPointerException());
            return false;
        }
        List<String> uids = AlwaysMoreItems.getStackHelper().getUniqueIdentifiersWithWildcard(itemStack);
        return uids.stream().anyMatch(this.itemBlacklist::contains);
    }
}

