package net.glasslauncher.mods.alwaysmoreitems.gui.widget;

import net.glasslauncher.mods.alwaysmoreitems.api.action.ActionButton;
import net.glasslauncher.mods.alwaysmoreitems.gui.RenderHelper;
import net.minecraft.class_18;
import net.minecraft.class_300;
import net.minecraft.class_31;
import net.minecraft.class_33;
import net.minecraft.class_34;
import net.minecraft.class_54;
import net.minecraft.client.Minecraft;
import net.modificationstation.stationapi.api.util.Identifier;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class ActionButtonWidget extends class_33 {
    ButtonIconType iconType;
    class_31 item;
    String texture;
    String altText;
    public ActionButton action;
    public Identifier actionIdentifier;

    String buttonText = "";

    protected ActionButtonWidget(int id, int x, int y, int width, int height) {
        super(id, x, y, width, height, "");
    }

    public ActionButtonWidget(int id, int x, int y, int width, int height, String texture) {
        this(id, x, y, width, height);
        this.texture = texture;
        this.iconType = ButtonIconType.TEXTURE;
    }

    public ActionButtonWidget(int id, int x, int y, int width, int height, class_31 item) {
        this(id, x, y, width, height);
        this.item = item;
        this.iconType = ButtonIconType.ITEM;
    }

    /**
     * @param id      ID of the button
     * @param x       x position of the button on screen
     * @param y       y position of the button on screen
     * @param width   width of the button
     * @param height  height of the button
     * @param text    the text thats displayed normally
     * @param altText the text thats displayed when SHIFT is held, leave blank or null to be same as normal text
     */
    public ActionButtonWidget(int id, int x, int y, int width, int height, String text, String altText) {
        this(id, x, y, width, height);
        this.field_1372 = class_300.method_992().method_993(text);

        if (altText == null || altText.isEmpty()) {
            this.altText = class_300.method_992().method_993(text);
        } else {
            this.altText = class_300.method_992().method_993(altText);
        }

        this.iconType = ButtonIconType.TEXT;
    }

    public void performAction(Minecraft minecraft, class_18 world, class_54 player, boolean isOperator, int mouseButton, boolean holdingShift) {
        action.perform(minecraft, world, player, isOperator, mouseButton, holdingShift);
    }

    @Override
    public void method_1186(Minecraft minecraft, int mouseX, int mouseY) {
        if (!field_1375) {
            return;
        }

        class_34 fontrenderer = minecraft.field_2815;
        RenderHelper.bindTexture("/gui/gui.png");
        boolean isHovered = mouseX >= field_1370 && mouseY >= field_1371 && mouseX < field_1370 + field_1368 && mouseY < field_1371 + field_1369;
        int k = method_1187(isHovered);

        method_1936(field_1370, field_1371, 0, 46 + k * 20, field_1368 / 2, field_1369);
        method_1936(field_1370 + field_1368 / 2, field_1371, 200 - field_1368 / 2, 46 + k * 20, field_1368 / 2, field_1369 / 2);
        method_1936(field_1370, field_1371 + field_1369 / 2, 0, 46 + k * 20 + 20 - field_1369 / 2, field_1368 / 2, field_1369 / 2);
        method_1936(field_1370 + field_1368 / 2, field_1371 + field_1369 / 2, 200 - field_1368 / 2, 46 + k * 20 + 20 - field_1369 / 2, field_1368 / 2, field_1369 / 2);

        switch (iconType) {
            case ITEM -> {
                RenderHelper.enableItemLighting();
                RenderHelper.drawItemStack(field_1370 + 2, field_1371 + 2, item, false);
                RenderHelper.disableItemLighting();
            }
            case TEXTURE -> {
                GL11.glEnable(GL11.GL_BLEND);
                RenderHelper.bindTexture(texture);
                RenderHelper.drawTexture(field_1370 + 2, field_1371 + 2, field_1368 - 4, field_1369 - 4);
                GL11.glDisable(GL11.GL_BLEND);
            }
            case TEXT -> {
                buttonText = Keyboard.isKeyDown(Keyboard.KEY_LSHIFT) || Keyboard.isKeyDown(Keyboard.KEY_RSHIFT) ? altText : field_1372;

                if (!field_1374) {
                    method_1934(fontrenderer, buttonText, field_1370 + field_1368 / 2, field_1371 + (field_1369 - 8) / 2, 0xffa0a0a0);
                } else if (isHovered) {
                    method_1934(fontrenderer, buttonText, field_1370 + field_1368 / 2, field_1371 + (field_1369 - 8) / 2, 0xffffa0);
                } else {
                    method_1934(fontrenderer, buttonText, field_1370 + field_1368 / 2, field_1371 + (field_1369 - 8) / 2, 0xe0e0e0);
                }
            }
        }

        method_1188(minecraft, mouseX, mouseY); // postRender
    }

    public enum ButtonIconType {
        ITEM,
        TEXTURE,
        TEXT,
        OTHER
    }
}
