/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.api;

import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.glasslauncher.mods.alwaysmoreitems.gui.AMIRarityIcons;
import net.glasslauncher.mods.alwaysmoreitems.gui.AMITextRenderer;

public enum Rarity {
    VANILLA("Vanilla", 'z', 0, new Color(255, 255, 255), new Color(0, 0, 0, 192), new Color(0, 0, 0, 192), HeaderCode.NONE),
    BAD("Bad", 'a', -1, new Color(AMITextRenderer.getColorFromCode('7')), HeaderCode.BAD),
    NONE("None", 'b', 0, new Color(AMITextRenderer.getColorFromCode('f')), HeaderCode.NONE),
    COMMON("Common", 'c', 1, new Color(AMITextRenderer.getColorFromCode('a')), HeaderCode.NONE),
    UNCOMMON("Uncommon", 'd', 2, new Color(AMITextRenderer.getColorFromCode('b')), HeaderCode.NORMAL),
    RARE("Rare", 'e', 3, new Color(AMITextRenderer.getColorFromCode('d')), HeaderCode.NORMAL),
    UNIQUE("Unique", 'f', 4, new Color(AMITextRenderer.getColorFromCode('e')), HeaderCode.FANCY),
    LEGENDARY("Legendary", 'g', 5, new Color(43, 194, 154), new Color(150, 39, 25), new Color(43, 194, 154).darker(), HeaderCode.FANCY),
    ARTEFACT("Artefact", 'h', 6, new Color(208, 75, 18), new Color(AMITextRenderer.getColorFromCode('6')), Color.GRAY, HeaderCode.ARTEFACT);

    public static final Map<Character, Rarity> AMI_RARITIES_BY_CODE;
    public final String name;
    public final Integer value;
    public final Color textColor;
    public final Color backgroundColor;
    public final Color iconColor;
    public final char injectionCode;
    public final HeaderCode headerCode;
    public final String code;

    private Rarity(String name, char injectionCode, Integer value, Color color, HeaderCode headerCode) {
        this.name = name;
        this.value = value;
        this.textColor = color;
        int intColor = color.darker().darker().getRGB();
        float red = (float)(intColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(intColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(intColor & 0xFF) / 255.0f;
        this.backgroundColor = new Color(red, green, blue, 0.7529412f);
        this.iconColor = color.darker();
        this.injectionCode = injectionCode;
        this.headerCode = headerCode;
        this.code = String.valueOf('\u00d7') + injectionCode;
    }

    private Rarity(String name, char injectionCode, Integer value, Color textColor, Color backgroundColor, Color iconColor, HeaderCode headerCode) {
        this.name = name;
        this.value = value;
        this.textColor = textColor;
        int intColor = backgroundColor.getRGB();
        float red = (float)(intColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(intColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(intColor & 0xFF) / 255.0f;
        this.backgroundColor = new Color(red, green, blue, 0.7529412f);
        this.iconColor = iconColor;
        this.injectionCode = injectionCode;
        this.headerCode = headerCode;
        this.code = String.valueOf('\u00d7') + injectionCode;
    }

    public String toString() {
        return this.code;
    }

    static {
        AMI_RARITIES_BY_CODE = new HashMap<Character, Rarity>(){
            {
                Arrays.stream(Rarity.values()).forEach((? super T rarity) -> this.put(Character.valueOf(rarity.injectionCode), rarity));
            }
        };
    }

    public static enum HeaderCode {
        BAD("Bad", '1', -1, AMIRarityIcons.BAD, false),
        NONE("None", '2', 0, AMIRarityIcons.NONE, false),
        NORMAL("Normal", '3', 1, AMIRarityIcons.NORMAL, false),
        FANCY("Fancy", '4', 2, AMIRarityIcons.FANCY, true),
        ARTEFACT("Artefact", '5', 3, AMIRarityIcons.ARTEFACT, false);

        public static final char PREFIX_CHARACTER = '\u00d7';
        public final String name;
        public final char injectionChar;
        public final int value;
        public final boolean[][] icon;
        public final boolean edgesStretchAcross;

        private HeaderCode(String name, char injectionChar, int value, boolean[][] icon, boolean edgesStretchAcross) {
            this.name = name;
            this.injectionChar = injectionChar;
            this.value = value;
            this.icon = icon;
            this.edgesStretchAcross = edgesStretchAcross;
        }

        public String toString() {
            return this.name;
        }
    }
}

