/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.recipe;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.glasslauncher.mods.alwaysmoreitems.config.AMIConfig;
import net.glasslauncher.mods.alwaysmoreitems.util.AlwaysMoreItems;
import net.minecraft.class_124;
import net.minecraft.class_31;
import net.minecraft.class_8;

public class NbtIgnoreList
implements net.glasslauncher.mods.alwaysmoreitems.api.NbtIgnoreList {
    private final Set<String> nbtTagNameBlacklist = new HashSet<String>();
    private final HashMultimap<class_124, String> itemNbtTagNameBlacklist = HashMultimap.create();

    @Override
    public void ignoreNbtTagNames(@Nullable class_124 item, String ... nbtTagNames) {
        if (item == null) {
            AlwaysMoreItems.LOGGER.error("Null item", (Throwable)new NullPointerException());
            return;
        }
        Set ignoredNbtTagNames = this.itemNbtTagNameBlacklist.get((Object)item);
        Collections.addAll(ignoredNbtTagNames, nbtTagNames);
    }

    @Override
    public boolean isNbtTagIgnored(@Nullable String nbtTagName) {
        if (nbtTagName == null) {
            AlwaysMoreItems.LOGGER.error("Null nbtTagName", (Throwable)new NullPointerException());
            return false;
        }
        return AMIConfig.INSTANCE.nbtBlacklist.contains(nbtTagName) || this.nbtTagNameBlacklist.contains(nbtTagName);
    }

    @Override
    @Nullable
    public class_8 getNbt(@Nullable class_31 itemStack) {
        if (itemStack == null) {
            AlwaysMoreItems.LOGGER.error("Null itemStack", (Throwable)new NullPointerException());
            return null;
        }
        class_8 nbtTagCompound = itemStack.getStationNbt();
        if (nbtTagCompound == null) {
            return null;
        }
        Set<String> keys = nbtTagCompound.always_More_Items$getKeySet();
        Set allIgnoredKeysForItem = this.itemNbtTagNameBlacklist.get((Object)itemStack.method_694());
        Sets.SetView ignoredKeysConfig = Sets.intersection(keys, new HashSet<String>(AMIConfig.INSTANCE.nbtBlacklist));
        Sets.SetView ignoredKeysApi = Sets.intersection(keys, this.nbtTagNameBlacklist);
        Sets.SetView ignoredKeysApiForItem = Sets.intersection(keys, (Set)allIgnoredKeysForItem);
        Sets.SetView ignoredKeys = Sets.union((Set)ignoredKeysConfig, (Set)ignoredKeysApi);
        if ((ignoredKeys = Sets.union((Set)ignoredKeys, (Set)ignoredKeysApiForItem)).isEmpty()) {
            return nbtTagCompound;
        }
        class_8 nbtTagCompoundCopy = nbtTagCompound.copy();
        for (String ignoredKey : ignoredKeys) {
            nbtTagCompoundCopy.always_More_Items$removeTag(ignoredKey);
        }
        return nbtTagCompoundCopy;
    }
}

