/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.gui.widget.ingredients;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.glasslauncher.mods.alwaysmoreitems.api.gui.TooltipCallback;
import net.glasslauncher.mods.alwaysmoreitems.gui.AMIDrawContext;
import net.glasslauncher.mods.alwaysmoreitems.gui.RenderHelper;
import net.glasslauncher.mods.alwaysmoreitems.gui.Tooltip;
import net.glasslauncher.mods.alwaysmoreitems.gui.widget.ingredients.IGuiIngredient;
import net.glasslauncher.mods.alwaysmoreitems.gui.widget.ingredients.IIngredientHelper;
import net.glasslauncher.mods.alwaysmoreitems.gui.widget.ingredients.IIngredientRenderer;
import net.glasslauncher.mods.alwaysmoreitems.recipe.Focus;
import net.glasslauncher.mods.alwaysmoreitems.util.AlwaysMoreItems;
import net.glasslauncher.mods.alwaysmoreitems.util.CycleTimer;
import net.minecraft.class_32;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class GuiIngredient<T>
extends class_32
implements IGuiIngredient<T> {
    private final int slotIndex;
    private final boolean input;
    private final int xPosition;
    private final int yPosition;
    private final int width;
    private final int height;
    private final int padding;
    @Nonnull
    private final CycleTimer cycleTimer;
    @Nonnull
    private final List<T> contained = new ArrayList<T>();
    @Nonnull
    private final List<T> allContained = new ArrayList<T>();
    @Nonnull
    private final IIngredientRenderer<T> ingredientRenderer;
    @Nonnull
    private final IIngredientHelper<T> ingredientHelper;
    @Nullable
    private TooltipCallback<T> tooltipCallback;
    private boolean enabled;

    public GuiIngredient(@Nonnull IIngredientRenderer<T> ingredientRenderer, @Nonnull IIngredientHelper<T> ingredientHelper, int slotIndex, boolean input, int xPosition, int yPosition, int width, int height, int padding, int itemCycleOffset) {
        this.ingredientRenderer = ingredientRenderer;
        this.ingredientHelper = ingredientHelper;
        this.slotIndex = slotIndex;
        this.input = input;
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.width = width;
        this.height = height;
        this.padding = padding;
        this.cycleTimer = new CycleTimer(itemCycleOffset);
    }

    @Override
    public void clear() {
        this.enabled = false;
        this.contained.clear();
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.enabled && mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
    }

    @Override
    @Nullable
    public T get() {
        return this.cycleTimer.getCycledItem(this.contained);
    }

    @Override
    @Nonnull
    public List<T> getAll() {
        return this.allContained;
    }

    @Override
    public void set(@Nonnull T contained, @Nonnull Focus focus) {
        this.set((Collection<T>)Collections.singleton(contained), focus);
    }

    @Override
    public void set(@Nonnull Collection<T> contained, @Nonnull Focus focus) {
        this.contained.clear();
        this.allContained.clear();
        contained = this.ingredientHelper.expandSubtypes(contained);
        Object match = null;
        if (this.isInput() && focus.getMode() == Focus.Mode.INPUT || !this.isInput() && focus.getMode() == Focus.Mode.OUTPUT) {
            match = this.ingredientHelper.getMatch(contained, focus);
        }
        if (match != null) {
            this.contained.add(match);
        } else {
            this.contained.addAll(contained);
        }
        this.allContained.addAll(contained);
        this.enabled = !this.contained.isEmpty();
    }

    public void setTooltipCallback(@Nullable TooltipCallback<T> tooltipCallback) {
        this.tooltipCallback = tooltipCallback;
    }

    @Override
    public void draw(@Nonnull Minecraft minecraft) {
        this.cycleTimer.onDraw();
        T value = this.get();
        this.ingredientRenderer.draw(minecraft, this.xPosition + this.padding, this.yPosition + this.padding, value);
    }

    @Override
    public void drawHovered(@Nonnull Minecraft minecraft, int mouseX, int mouseY) {
        T value = this.get();
        if (value == null) {
            return;
        }
        this.draw(minecraft);
        this.drawTooltip(minecraft, mouseX, mouseY, value);
    }

    @Override
    public void drawHighlight(@Nonnull Minecraft minecraft, Color color, int xOffset, int yOffset) {
        int x = this.xPosition + xOffset + this.padding;
        int y = this.yPosition + yOffset + this.padding;
        GL11.glDisable((int)2896);
        AMIDrawContext.INSTANCE.method_1932(x, y, x + this.width - this.padding * 2, y + this.height - this.padding * 2, color.getRGB());
    }

    private void drawTooltip(@Nonnull Minecraft minecraft, int mouseX, int mouseY, @Nonnull T value) {
        try {
            GL11.glDisable((int)2929);
            RenderHelper.disableLighting();
            AMIDrawContext.INSTANCE.method_1932(this.xPosition + this.padding, this.yPosition + this.padding, this.xPosition + this.width - this.padding, this.yPosition + this.height - this.padding, Integer.MAX_VALUE);
            ArrayList<Object> tooltip = this.ingredientRenderer.getTooltip(minecraft, value);
            if (this.tooltipCallback != null) {
                this.tooltipCallback.onTooltip(this.slotIndex, this.input, value, tooltip);
            }
            Tooltip.INSTANCE.setTooltip(tooltip, mouseX, mouseY);
            GL11.glEnable((int)2929);
        }
        catch (RuntimeException e) {
            AlwaysMoreItems.LOGGER.error("Exception when rendering tooltip on {}.", value, (Object)e);
        }
    }

    @Override
    public boolean isInput() {
        return this.input;
    }
}

