/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.init;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.glasslauncher.mods.alwaysmoreitems.api.ModPluginProvider;
import net.glasslauncher.mods.alwaysmoreitems.api.event.ActionButtonRegisterEvent;
import net.glasslauncher.mods.alwaysmoreitems.network.c2s.ActionButtonPacket;
import net.glasslauncher.mods.alwaysmoreitems.network.c2s.GiveItemPacket;
import net.glasslauncher.mods.alwaysmoreitems.network.c2s.RecipeTransferPacket;
import net.glasslauncher.mods.alwaysmoreitems.network.s2c.RecipeSyncPacket;
import net.glasslauncher.mods.alwaysmoreitems.registry.AMIItemRegistry;
import net.glasslauncher.mods.alwaysmoreitems.registry.RecipeRegistry;
import net.glasslauncher.mods.alwaysmoreitems.util.AMIHelpers;
import net.glasslauncher.mods.alwaysmoreitems.util.AlwaysMoreItems;
import net.glasslauncher.mods.alwaysmoreitems.util.ModRegistry;
import net.mine_diver.unsafeevents.Event;
import net.mine_diver.unsafeevents.listener.EventListener;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.event.init.InitFinishedEvent;
import net.modificationstation.stationapi.api.event.network.packet.PacketRegisterEvent;
import net.modificationstation.stationapi.api.mod.entrypoint.Entrypoint;
import net.modificationstation.stationapi.api.mod.entrypoint.EntrypointManager;
import net.modificationstation.stationapi.api.mod.entrypoint.EventBusPolicy;
import net.modificationstation.stationapi.api.registry.PacketTypeRegistry;
import net.modificationstation.stationapi.api.registry.Registry;
import net.modificationstation.stationapi.api.util.Identifier;

@Entrypoint(eventBus=@EventBusPolicy(registerInstance=false))
public class CommonInit {
    private static ImmutableMap<Identifier, ModPluginProvider> plugins;
    private static ModRegistry modRegistry;

    @EventListener
    public static void init(InitFinishedEvent event) {
        AlwaysMoreItems.setHelpers(new AMIHelpers());
        CommonInit.initPlugins();
        FabricLoader.getInstance().getEntrypointContainers("alwaysmoreitems:action", Object.class).forEach(EntrypointManager::setup);
        StationAPI.EVENT_BUS.post((Event)new ActionButtonRegisterEvent());
        CommonInit.initAMI();
    }

    public static void initPlugins() {
        LinkedHashMap<Object, ModPluginProvider> pluginsMap = new LinkedHashMap<Object, ModPluginProvider>();
        FabricLoader.getInstance().getEntrypointContainers("alwaysmoreitems:plugin", ModPluginProvider.class).stream().map(EntrypointContainer::getEntrypoint).forEach(iModPlugin -> pluginsMap.put(iModPlugin.getId(), (ModPluginProvider)iModPlugin));
        LinkedHashMap oldPlugins = new LinkedHashMap(pluginsMap);
        pluginsMap.clear();
        pluginsMap.put(AlwaysMoreItems.NAMESPACE.id("vanilla"), (ModPluginProvider)oldPlugins.remove(AlwaysMoreItems.NAMESPACE.id("vanilla")));
        pluginsMap.putAll(oldPlugins);
        pluginsMap.values().forEach(iModPlugin -> {
            try {
                iModPlugin.onAMIHelpersAvailable(AlwaysMoreItems.getHelpers());
            }
            catch (RuntimeException e) {
                AlwaysMoreItems.LOGGER.error("Mod plugin failed: {}/{}", (Object)iModPlugin.getId(), iModPlugin.getClass(), (Object)e);
                pluginsMap.remove(iModPlugin.getId());
            }
        });
        plugins = ImmutableMap.copyOf(pluginsMap);
    }

    @EventListener
    public static void registerPackets(PacketRegisterEvent event) {
        Registry.register((Registry)PacketTypeRegistry.INSTANCE, (Identifier)AlwaysMoreItems.NAMESPACE.id("action_button"), ActionButtonPacket.TYPE);
        Registry.register((Registry)PacketTypeRegistry.INSTANCE, (Identifier)AlwaysMoreItems.NAMESPACE.id("give_item"), GiveItemPacket.TYPE);
        Registry.register((Registry)PacketTypeRegistry.INSTANCE, (Identifier)AlwaysMoreItems.NAMESPACE.id("transfer"), RecipeTransferPacket.TYPE);
        Registry.register((Registry)PacketTypeRegistry.INSTANCE, (Identifier)AlwaysMoreItems.NAMESPACE.id("sync"), RecipeSyncPacket.TYPE);
    }

    public static void initAMI() {
        AlwaysMoreItems.setStarted(true);
        AMIItemRegistry itemRegistry = new AMIItemRegistry();
        AlwaysMoreItems.setItemRegistry(itemRegistry);
        HashMap plugins = (HashMap)CommonInit.getPlugins().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        plugins.values().forEach(iModPlugin -> {
            try {
                iModPlugin.onItemRegistryAvailable(itemRegistry);
            }
            catch (RuntimeException e) {
                AlwaysMoreItems.LOGGER.error("Mod plugin failed: {}/{}", (Object)iModPlugin.getId(), iModPlugin.getClass(), (Object)e);
                plugins.remove(iModPlugin.getId());
            }
        });
        modRegistry = new ModRegistry();
        plugins.values().forEach(iModPlugin -> {
            try {
                iModPlugin.register(modRegistry);
                AlwaysMoreItems.LOGGER.info("Registered plugin: {}/{}", (Object)iModPlugin.getId(), (Object)iModPlugin.getClass().getName());
            }
            catch (RuntimeException e) {
                AlwaysMoreItems.LOGGER.error("Mod plugin failed: {}/{}", (Object)iModPlugin.getId(), iModPlugin.getClass(), (Object)e);
                plugins.remove(iModPlugin.getId());
            }
        });
        RecipeRegistry recipeRegistry = modRegistry.createRecipeRegistry();
        AlwaysMoreItems.setRecipeRegistry(recipeRegistry);
        plugins.values().forEach(iModPlugin -> {
            AlwaysMoreItems.LOGGER.info("Initializing plugin {}", (Object)iModPlugin.getName());
            try {
                iModPlugin.onRecipeRegistryAvailable(recipeRegistry);
            }
            catch (RuntimeException e) {
                AlwaysMoreItems.LOGGER.error("Mod plugin failed: {}/{}", (Object)iModPlugin.getId(), iModPlugin.getClass(), (Object)e);
                plugins.remove(iModPlugin.getId());
            }
        });
        CommonInit.plugins = ImmutableMap.copyOf((Map)plugins);
    }

    public static ImmutableMap<Identifier, ModPluginProvider> getPlugins() {
        return plugins;
    }

    public static ModRegistry getModRegistry() {
        return modRegistry;
    }
}

