/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.plugins.ami.description;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.glasslauncher.mods.alwaysmoreitems.api.gui.AMIDrawable;
import net.glasslauncher.mods.alwaysmoreitems.api.recipe.RecipeWrapper;
import net.glasslauncher.mods.alwaysmoreitems.gui.AMITextRenderer;
import net.glasslauncher.mods.alwaysmoreitems.gui.DrawableHelper;
import net.glasslauncher.mods.alwaysmoreitems.util.MathUtil;
import net.minecraft.class_300;
import net.minecraft.class_31;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.NotNull;

public class ItemDescriptionRecipe
implements RecipeWrapper {
    private static final int lineSpacing = 2;
    @Nonnull
    private final List<String> description;
    @Nonnull
    private final List<List<class_31>> outputs;
    @Nonnull
    private final AMIDrawable slotDrawable;

    public static List<ItemDescriptionRecipe> create(@Nonnull List<class_31> itemStacks, String ... descriptionKeys) {
        ArrayList<ItemDescriptionRecipe> recipes = new ArrayList<ItemDescriptionRecipe>();
        List<String> descriptionLines = ItemDescriptionRecipe.translateDescriptionLines(descriptionKeys);
        descriptionLines = ItemDescriptionRecipe.expandNewlines(descriptionLines);
        descriptionLines = ItemDescriptionRecipe.wrapDescriptionLines(descriptionLines);
        int lineCount = descriptionLines.size();
        int maxLinesPerPage = 9;
        int pageCount = MathUtil.divideCeil(lineCount, 9);
        for (int i = 0; i < pageCount; ++i) {
            int startLine = i * 9;
            int endLine = Math.min((i + 1) * 9, lineCount);
            List<String> description = descriptionLines.subList(startLine, endLine);
            ItemDescriptionRecipe recipe = new ItemDescriptionRecipe(itemStacks, description);
            recipes.add(recipe);
        }
        return recipes;
    }

    @Nonnull
    private static List<String> translateDescriptionLines(String ... descriptionKeys) {
        ArrayList<String> descriptionLines = new ArrayList<String>();
        for (String descriptionKey : descriptionKeys) {
            String translatedLine = class_300.method_992().method_993(descriptionKey);
            descriptionLines.add(translatedLine);
        }
        return descriptionLines;
    }

    @Nonnull
    private static List<String> expandNewlines(@Nonnull List<String> descriptionLines) {
        ArrayList<String> descriptionLinesExpanded = new ArrayList<String>();
        for (String descriptionLine : descriptionLines) {
            String[] descriptionLineExpanded = descriptionLine.split("\\\\n");
            Collections.addAll(descriptionLinesExpanded, descriptionLineExpanded);
        }
        return descriptionLinesExpanded;
    }

    @Nonnull
    private static List<String> wrapDescriptionLines(@Nonnull List<String> descriptionLines) {
        if (FabricLoader.getInstance().getEnvironmentType().equals((Object)EnvType.SERVER)) {
            return Collections.emptyList();
        }
        ArrayList<String> descriptionLinesWrapped = new ArrayList<String>();
        for (String descriptionLine : descriptionLines) {
            List<String> textLines = AMITextRenderer.INSTANCE.listFormattedStringToWidth(descriptionLine, 160);
            descriptionLinesWrapped.addAll(textLines);
        }
        return descriptionLinesWrapped;
    }

    public ItemDescriptionRecipe(@Nonnull List<class_31> itemStacks, @Nonnull List<String> description) {
        this.description = description;
        this.outputs = Collections.singletonList(itemStacks);
        this.slotDrawable = DrawableHelper.createDrawable("/gui/furnace.png", 55, 16, 18, 18);
    }

    @Override
    public List<?> getInputs() {
        return Collections.emptyList();
    }

    @Nonnull
    public List<List<class_31>> getOutputs() {
        return this.outputs;
    }

    @Override
    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        int xPos = (recipeWidth - this.slotDrawable.getWidth()) / 2;
        int yPos = 0;
        this.slotDrawable.draw(minecraft, xPos, yPos);
        xPos = 0;
        yPos += this.slotDrawable.getHeight() + 4;
        for (String descriptionLine : this.description) {
            AMITextRenderer.INSTANCE.method_1906(descriptionLine, xPos, yPos, Color.black.getRGB());
            yPos += 11;
        }
    }

    @Override
    public void drawAnimations(@NotNull Minecraft minecraft, int recipeWidth, int recipeHeight) {
    }

    @Override
    public ArrayList<Object> getTooltip(int mouseX, int mouseY) {
        return null;
    }

    @Override
    public boolean handleClick(@NotNull Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return false;
    }

    @Nonnull
    public List<String> getDescription() {
        return this.description;
    }
}

