/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.transfer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.glasslauncher.mods.alwaysmoreitems.api.gui.GuiItemStackGroup;
import net.glasslauncher.mods.alwaysmoreitems.api.gui.RecipeLayout;
import net.glasslauncher.mods.alwaysmoreitems.api.recipe.transfer.RecipeTransferError;
import net.glasslauncher.mods.alwaysmoreitems.api.recipe.transfer.RecipeTransferHandler;
import net.glasslauncher.mods.alwaysmoreitems.api.recipe.transfer.RecipeTransferInfo;
import net.glasslauncher.mods.alwaysmoreitems.gui.widget.ingredients.IGuiIngredient;
import net.glasslauncher.mods.alwaysmoreitems.network.c2s.RecipeTransferPacket;
import net.glasslauncher.mods.alwaysmoreitems.transfer.RecipeTransferHandlerHelper;
import net.glasslauncher.mods.alwaysmoreitems.util.AlwaysMoreItems;
import net.glasslauncher.mods.alwaysmoreitems.util.StackHelper;
import net.minecraft.class_133;
import net.minecraft.class_169;
import net.minecraft.class_300;
import net.minecraft.class_31;
import net.minecraft.class_54;
import net.minecraft.class_71;
import net.modificationstation.stationapi.api.network.packet.PacketHelper;

public class BasicRecipeTransferHandler
implements RecipeTransferHandler {
    @Nonnull
    private final RecipeTransferInfo transferHelper;

    public BasicRecipeTransferHandler(@Nonnull RecipeTransferInfo transferHelper) {
        this.transferHelper = transferHelper;
    }

    @Override
    public Class<? extends class_71> getContainerClass() {
        return this.transferHelper.getContainerClass();
    }

    @Override
    public String getRecipeCategoryUid() {
        return this.transferHelper.getRecipeCategoryUid();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public RecipeTransferError transferRecipe(@Nonnull class_71 container, @Nonnull RecipeLayout recipeLayout, @Nonnull class_54 player, boolean maxTransfer, boolean doTransfer) {
        void var10_13;
        RecipeTransferHandlerHelper handlerHelper = AlwaysMoreItems.getHelpers().recipeTransferHandlerHelper();
        StackHelper stackHelper = AlwaysMoreItems.getStackHelper();
        if (!AlwaysMoreItems.isAMIOnServer()) {
            return handlerHelper.createInternalError();
        }
        HashMap<Integer, class_133> inventorySlots = new HashMap<Integer, class_133>();
        for (class_133 class_1332 : this.transferHelper.getInventorySlots(container)) {
            inventorySlots.put(class_1332.field_499, class_1332);
        }
        HashMap<Integer, class_133> craftingSlots = new HashMap<Integer, class_133>();
        for (class_133 slot : this.transferHelper.getRecipeSlots(container)) {
            craftingSlots.put(slot.field_499, slot);
        }
        boolean bl = false;
        GuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        for (IGuiIngredient ingredient : itemStackGroup.getGuiIngredients().values()) {
            if (!ingredient.isInput() || ingredient.getAll().isEmpty()) continue;
            ++var10_13;
        }
        if (var10_13 > craftingSlots.size()) {
            AlwaysMoreItems.LOGGER.error("Recipe Transfer helper {} does not work for container {}", this.transferHelper.getClass(), container.getClass());
            return handlerHelper.createInternalError();
        }
        ArrayList<class_31> availableItemStacks = new ArrayList<class_31>();
        int filledCraftSlotCount = 0;
        int emptySlotCount = 0;
        for (class_133 slot : craftingSlots.values()) {
            if (!slot.method_476()) continue;
            if (slot.method_473(0) == null) {
                AlwaysMoreItems.LOGGER.error("Recipe Transfer helper {} does not work for container {}. Player can't move item out of Crafting Slot number {}", this.transferHelper.getClass(), container.getClass(), (Object)slot.field_499);
                return handlerHelper.createInternalError();
            }
            ++filledCraftSlotCount;
            availableItemStacks.add(slot.method_472().method_724());
        }
        for (class_133 slot : inventorySlots.values()) {
            if (slot.method_476()) {
                availableItemStacks.add(slot.method_472().method_724());
                continue;
            }
            ++emptySlotCount;
        }
        if (filledCraftSlotCount - var10_13 > emptySlotCount) {
            String message = class_300.method_992().method_993("alwaysmoreitems.tooltip.error.recipe.transfer.inventory.full");
            return handlerHelper.createUserErrorWithTooltip(message);
        }
        StackHelper.MatchingItemsResult matchingItemsResult = stackHelper.getMatchingItems(availableItemStacks, itemStackGroup.getGuiIngredients());
        if (!matchingItemsResult.missingItems.isEmpty()) {
            String message = class_300.method_992().method_993("alwaysmoreitems.tooltip.error.recipe.transfer.missing");
            return handlerHelper.createUserErrorForSlots(message, matchingItemsResult.missingItems);
        }
        ArrayList<Integer> craftingSlotIndexes = new ArrayList<Integer>(craftingSlots.keySet());
        Collections.sort(craftingSlotIndexes);
        ArrayList<Integer> inventorySlotIndexes = new ArrayList<Integer>(inventorySlots.keySet());
        Collections.sort(inventorySlotIndexes);
        for (Map.Entry<Integer, class_31> entry : matchingItemsResult.matchingItems.entrySet()) {
            int craftNumber = entry.getKey();
            int slotNumber = (Integer)craftingSlotIndexes.get(craftNumber);
            if (slotNumber >= container.field_2734.size()) {
                AlwaysMoreItems.LOGGER.error("Recipes Transfer Helper {} references slot {} outside of the inventory's size {}", this.transferHelper.getClass(), (Object)slotNumber, (Object)container.field_2734.size());
                return handlerHelper.createInternalError();
            }
            class_133 slot = container.method_2084(slotNumber);
            class_31 stack = entry.getValue();
            if (slot == null) {
                AlwaysMoreItems.LOGGER.error("The slot number {} does not exist in the container.", (Object)slotNumber);
                return handlerHelper.createInternalError();
            }
            if (slot.method_477(stack)) continue;
            AlwaysMoreItems.LOGGER.error("The ItemStack {} is not valid for the slot number {}", (Object)stack, (Object)slotNumber);
            return handlerHelper.createInternalError();
        }
        if (doTransfer) {
            RecipeTransferPacket packet = new RecipeTransferPacket(matchingItemsResult.matchingItems, craftingSlotIndexes, inventorySlotIndexes, maxTransfer);
            PacketHelper.send((class_169)packet);
        }
        return null;
    }

    public static void setItems(@Nonnull class_54 player, @Nonnull Map<Integer, class_31> slotMap, @Nonnull List<Integer> craftingSlots, @Nonnull List<Integer> inventorySlots, boolean maxTransfer) {
        class_71 container = player.field_521;
        StackHelper stackHelper = AlwaysMoreItems.getStackHelper();
        int removedSets = BasicRecipeTransferHandler.removeSetsFromInventory(container, slotMap.values(), craftingSlots, inventorySlots, maxTransfer);
        if (removedSets == 0) {
            return;
        }
        ArrayList<class_31> clearedCraftingItems = new ArrayList<class_31>();
        for (Integer n : craftingSlots) {
            class_133 craftingSlot = container.method_2084(n.intValue());
            if (craftingSlot == null || !craftingSlot.method_476()) continue;
            class_31 craftingItem = craftingSlot.method_473(Integer.MAX_VALUE);
            clearedCraftingItems.add(craftingItem);
        }
        for (Map.Entry entry : slotMap.entrySet()) {
            class_31 stack = (class_31)entry.getValue();
            if (stack.method_715()) {
                int maxSets = stack.method_709() / stack.field_751;
                stack.field_751 *= Math.min(maxSets, removedSets);
            }
            Integer craftNumber = (Integer)entry.getKey();
            Integer slotNumber = craftingSlots.get(craftNumber);
            class_133 slot = container.method_2084(slotNumber.intValue());
            slot.method_479(stack);
        }
        for (class_31 class_312 : clearedCraftingItems) {
            stackHelper.addStack(container, inventorySlots, class_312, true);
        }
        container.method_2075();
    }

    private static int removeSetsFromInventory(@Nonnull class_71 container, @Nonnull Collection<class_31> required, @Nonnull List<Integer> craftingSlots, @Nonnull List<Integer> inventorySlots, boolean maxTransfer) {
        if (maxTransfer) {
            ArrayList<class_31> requiredCopy = new ArrayList<class_31>(required);
            int removedSets = 0;
            while (!requiredCopy.isEmpty() && BasicRecipeTransferHandler.removeSetsFromInventory(container, requiredCopy, craftingSlots, inventorySlots)) {
                ++removedSets;
                Iterator iterator = requiredCopy.iterator();
                while (iterator.hasNext()) {
                    class_31 stack = (class_31)iterator.next();
                    if (stack.method_715() && stack.field_751 * (removedSets + 1) <= stack.method_709()) continue;
                    iterator.remove();
                }
            }
            return removedSets;
        }
        boolean success = BasicRecipeTransferHandler.removeSetsFromInventory(container, required, craftingSlots, inventorySlots);
        return success ? 1 : 0;
    }

    private static boolean removeSetsFromInventory(@Nonnull class_71 container, @Nonnull Iterable<class_31> required, @Nonnull List<Integer> craftingSlots, @Nonnull List<Integer> inventorySlots) {
        HashMap<class_133, class_31> originalSlotContents = new HashMap<class_133, class_31>();
        for (class_31 matchingStack : required) {
            class_31 requiredStack = matchingStack.method_724();
            while (requiredStack.field_751 > 0) {
                class_133 slot = BasicRecipeTransferHandler.getSlotWithStack(container, requiredStack, craftingSlots, inventorySlots);
                if (slot == null) {
                    for (Map.Entry slotEntry : originalSlotContents.entrySet()) {
                        class_31 stack = (class_31)slotEntry.getValue();
                        ((class_133)slotEntry.getKey()).method_479(stack);
                    }
                    return false;
                }
                if (!originalSlotContents.containsKey(slot)) {
                    originalSlotContents.put(slot, slot.method_472().method_724());
                }
                class_31 removed = slot.method_473(requiredStack.field_751);
                requiredStack.field_751 -= removed.field_751;
            }
        }
        return true;
    }

    private static class_133 getSlotWithStack(@Nonnull class_71 container, @Nonnull class_31 stack, @Nonnull List<Integer> craftingSlots, @Nonnull List<Integer> inventorySlots) {
        StackHelper stackHelper = AlwaysMoreItems.getStackHelper();
        class_133 slot = stackHelper.getSlotWithStack(container, craftingSlots, stack);
        if (slot == null) {
            slot = stackHelper.getSlotWithStack(container, inventorySlots, stack);
        }
        return slot;
    }
}

