/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Table;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.glasslauncher.mods.alwaysmoreitems.api.recipe.RecipeCategory;
import net.glasslauncher.mods.alwaysmoreitems.util.AlwaysMoreItems;
import net.glasslauncher.mods.alwaysmoreitems.util.RecipeCategoryComparator;
import net.glasslauncher.mods.alwaysmoreitems.util.StackHelper;
import net.minecraft.class_31;

public class RecipeMap {
    @Nonnull
    private final Table<RecipeCategory, String, List<Object>> recipeTable = HashBasedTable.create();
    @Nonnull
    private final ArrayListMultimap<String, RecipeCategory> categoryMap = ArrayListMultimap.create();
    @Nonnull
    private final Ordering<RecipeCategory> recipeCategoryOrdering;

    public RecipeMap(RecipeCategoryComparator recipeCategoryComparator) {
        this.recipeCategoryOrdering = Ordering.from((Comparator)recipeCategoryComparator);
    }

    @Nonnull
    public ImmutableList<RecipeCategory> getRecipeCategories(@Nonnull class_31 itemStack) {
        HashSet recipeCategories = new HashSet();
        for (String stackKey : AlwaysMoreItems.getStackHelper().getUniqueIdentifiersWithWildcard(itemStack)) {
            recipeCategories.addAll(this.categoryMap.get((Object)stackKey));
        }
        return this.recipeCategoryOrdering.immutableSortedCopy(recipeCategories);
    }

    private void addRecipeCategory(@Nonnull RecipeCategory recipeCategory, @Nonnull class_31 itemStack) {
        String stackKey = AlwaysMoreItems.getStackHelper().getUniqueIdentifierForStack(itemStack);
        List recipeCategories = this.categoryMap.get((Object)stackKey);
        if (!recipeCategories.contains(recipeCategory)) {
            recipeCategories.add(recipeCategory);
        }
    }

    @Nonnull
    public ImmutableList<Object> getRecipes(@Nonnull RecipeCategory recipeCategory, @Nonnull class_31 stack) {
        Map recipesForType = this.recipeTable.row((Object)recipeCategory);
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (String name : AlwaysMoreItems.getStackHelper().getUniqueIdentifiersWithWildcard(stack)) {
            List recipes = (List)recipesForType.get(name);
            if (recipes == null) continue;
            listBuilder.addAll((Iterable)recipes);
        }
        return listBuilder.build();
    }

    public void addRecipe(@Nonnull Object recipe, @Nonnull RecipeCategory recipeCategory, @Nonnull Iterable<class_31> itemStacks) {
        Map recipesForType = this.recipeTable.row((Object)recipeCategory);
        StackHelper stackHelper = AlwaysMoreItems.getStackHelper();
        for (class_31 itemStack : itemStacks) {
            if (itemStack == null) continue;
            String stackKey = stackHelper.getUniqueIdentifierForStack(itemStack);
            List recipes = recipesForType.computeIfAbsent(stackKey, k -> Lists.newArrayList());
            recipes.add(recipe);
            this.addRecipeCategory(recipeCategory, itemStack);
        }
    }
}

