package net.glasslauncher.mods.alwaysmoreitems.api;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_31;
import net.minecraft.class_8;

public interface NbtIgnoreList {
    /**
     * Tell AMI to ignore NBT tags on a specific item when comparing items for recipes.
     * NBT is automatically ignored on items that don't have subtypes.
     */
    void ignoreNbtTagNames(@Nonnull class_124 item, String... nbtTagNames);

    /**
     * Check to see if an NBT tag is ignored.
     */
    boolean isNbtTagIgnored(@Nonnull String nbtTagName);

    /**
     * Get NBT from an itemStack, minus the NBT that is being ignored.
     * Returns null if the itemStack has no NBT.
     */
    @Nullable
    class_8 getNbt(@Nonnull class_31 itemStack);
}
